/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.support.md.impl;

import com.github.houbb.markdown.toc.exception.MarkdownTocRuntimeException;
import com.github.houbb.markdown.toc.support.I18N;
import com.github.houbb.markdown.toc.support.md.MarkdownFileToc;
import com.github.houbb.markdown.toc.support.md.impl.AtxMarkdownContentToc;
import com.github.houbb.markdown.toc.util.FileUtil;
import com.github.houbb.markdown.toc.vo.TocGen;
import com.github.houbb.markdown.toc.vo.config.TocConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.0")
public class AtxMarkdownFileToc
implements MarkdownFileToc {
    @Override
    public TocGen genTocFile(String filePath, TocConfig config) {
        Path path = Paths.get(filePath, new String[0]);
        return this.genTocForFile(path, config);
    }

    private TocGen genTocForFile(Path path, TocConfig config) {
        try {
            AtxMarkdownContentToc markdownContentToc = new AtxMarkdownContentToc(config);
            if (!FileUtil.isMdFile(path.toString())) {
                throw new MarkdownTocRuntimeException(I18N.get("onlySupportMdFile"));
            }
            List<String> contentList = Files.readAllLines(path, config.getCharset());
            List<String> trimTocContentList = markdownContentToc.getPureContentList(contentList);
            List<String> tocList = markdownContentToc.getPureTocList(trimTocContentList);
            TocGen tocGen = new TocGen(path.toString(), tocList);
            if (config.isWrite()) {
                ArrayList<String> resultList = new ArrayList<String>(tocList);
                resultList.addAll(trimTocContentList);
                Files.write(path, resultList, config.getCharset(), new OpenOption[0]);
            }
            return tocGen;
        }
        catch (IOException e) {
            throw new MarkdownTocRuntimeException(e);
        }
    }
}

