/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.util;

import com.github.houbb.markdown.toc.exception.MarkdownTocRuntimeException;
import com.github.houbb.markdown.toc.support.MarkdownFileWalker;
import com.github.houbb.markdown.toc.util.ArrayUtil;
import com.github.houbb.markdown.toc.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED, since="1.0.0")
public final class FileUtil {
    private FileUtil() {
    }

    public static boolean isMdFile(String filePath) {
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        return filePath.endsWith(".md") || filePath.endsWith(".markdown");
    }

    public static List<Path> getMdFilePathList(Path dirPath, boolean subTree) {
        try {
            if (subTree) {
                MarkdownFileWalker markdownFileWalker = new MarkdownFileWalker();
                Files.walkFileTree(dirPath, markdownFileWalker);
                return markdownFileWalker.getPathList();
            }
            File dir = dirPath.toFile();
            Object[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return FileUtil.isMdFile(name);
                }
            });
            if (ArrayUtil.isNotEmpty(files)) {
                ArrayList<Path> paths = new ArrayList<Path>();
                for (Object file : files) {
                    paths.add(((File)file).toPath());
                }
                return paths;
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new MarkdownTocRuntimeException(e);
        }
    }

    public static List<String> getFileContentEachLine(InputStream inputStream, int initLine) {
        LinkedList<String> contentList = new LinkedList<String>();
        String charset = "UTF-8";
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new MarkdownTocRuntimeException(e);
        }
        return contentList;
    }
}

