/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.util;

import com.github.houbb.markdown.toc.support.md.MarkdownFileToc;
import com.github.houbb.markdown.toc.support.md.impl.AtxMarkdownFileToc;
import com.github.houbb.markdown.toc.vo.TocGen;
import com.github.houbb.markdown.toc.vo.config.TocConfig;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.0")
public class ThreadLocalUtil {
    private static final ThreadLocal<MarkdownFileToc> FILE_TOC_THREAD_LOCAL = new ThreadLocal();

    public static TocGen genTocFile(String filePath, TocConfig tocConfig) {
        MarkdownFileToc fileToc = ThreadLocalUtil.getMarkdownFileToc();
        return fileToc.genTocFile(filePath, tocConfig);
    }

    public static void clear() {
        FILE_TOC_THREAD_LOCAL.remove();
    }

    private static MarkdownFileToc getMarkdownFileToc() {
        MarkdownFileToc fileToc = FILE_TOC_THREAD_LOCAL.get();
        if (null == fileToc) {
            fileToc = new AtxMarkdownFileToc();
            FILE_TOC_THREAD_LOCAL.set(fileToc);
        }
        return fileToc;
    }
}

