/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.markdown.toc.vo;

import com.github.houbb.markdown.toc.support.IncreaseMap;
import java.util.LinkedList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.0.0")
public class TocVo {
    private static final String ROOT_NAME = "ROOT";
    private String origin;
    private int level;
    private String tocTitle;
    private String tocHref;
    private TocVo parent;
    private List<TocVo> children = new LinkedList<TocVo>();
    private final IncreaseMap increaseMap;
    private int order;
    private String orderDesc;
    private String indent;

    public TocVo(String origin, IncreaseMap increaseMap) {
        this.origin = origin;
        this.increaseMap = increaseMap;
        this.init();
    }

    private void init() {
        if (ROOT_NAME.equals(this.origin)) {
            return;
        }
        String[] strings = this.origin.split("\\s+");
        this.tocTitle = this.origin.substring(strings[0].length()).trim();
        this.tocHref = this.increaseMap.buildActualName(this.tocTitle);
        this.level = strings[0].length();
    }

    public static TocVo rootToc(IncreaseMap increaseMap) {
        TocVo tocVo = new TocVo(ROOT_NAME, increaseMap);
        tocVo.setLevel(0);
        return tocVo;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getTocTitle() {
        return this.tocTitle;
    }

    public void setTocTitle(String tocTitle) {
        this.tocTitle = tocTitle;
    }

    public String getTocHref() {
        return this.tocHref;
    }

    public void setTocHref(String tocHref) {
        this.tocHref = tocHref;
    }

    public List<TocVo> getChildren() {
        return this.children;
    }

    public void setChildren(List<TocVo> children) {
        this.children = children;
    }

    public TocVo getParent() {
        return this.parent;
    }

    public void setParent(TocVo parent) {
        this.parent = parent;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getOrderDesc() {
        return this.orderDesc;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }
}

