/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.util;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.opencc4j.core.impl.ZhConvertBootstrap;
import com.github.houbb.opencc4j.support.segment.Segment;
import com.github.houbb.opencc4j.support.segment.impl.CharSegment;
import com.github.houbb.opencc4j.support.segment.impl.HuaBanSegment;
import java.util.List;

public final class ZhConverterUtil {
    private static final ZhConvertBootstrap CHAR_BS = ZhConvertBootstrap.newInstance((Segment)Instances.singleton(CharSegment.class));
    private static final ZhConvertBootstrap HUABAN_BS = ZhConvertBootstrap.newInstance((Segment)Instances.singleton(HuaBanSegment.class));

    private ZhConverterUtil() {
    }

    public static boolean isSimple(String charOrPhrase) {
        return HUABAN_BS.isSimple(charOrPhrase);
    }

    public static boolean isTraditional(String charOrPhrase) {
        return HUABAN_BS.isTraditional(charOrPhrase);
    }

    public static List<String> simpleList(String original) {
        return HUABAN_BS.simpleList(original);
    }

    public static List<String> traditionalList(String original) {
        return HUABAN_BS.traditionalList(original);
    }

    public static String toSimple(String original) {
        return ZhConverterUtil.convertToSimple(original);
    }

    public static String toTraditional(String original) {
        return ZhConverterUtil.convertToTraditional(original);
    }

    @Deprecated
    public static String convertToSimple(String original) {
        return ZhConverterUtil.convertToSimple(original, true);
    }

    @Deprecated
    public static String convertToTraditional(String original) {
        return ZhConverterUtil.convertToTraditional(original, true);
    }

    @Deprecated
    public static String convertToSimple(String original, boolean huabanSegment) {
        ZhConvertBootstrap zhConvertBootstrap = ZhConverterUtil.getConvertBs(huabanSegment);
        return zhConvertBootstrap.toSimple(original);
    }

    @Deprecated
    public static String convertToTraditional(String original, boolean huabanSegment) {
        ZhConvertBootstrap zhConvertBootstrap = ZhConverterUtil.getConvertBs(huabanSegment);
        return zhConvertBootstrap.toTraditional(original);
    }

    private static ZhConvertBootstrap getConvertBs(boolean huabanSegment) {
        if (huabanSegment) {
            return HUABAN_BS;
        }
        return CHAR_BS;
    }
}

