/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.impl.StringArrayValueConverter;
import com.github.houbb.property.support.converter.impl.StringCollectionValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.BooleanArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.ByteArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.CharArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.DoubleArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.FloatArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.IntArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.LongArrayValueConverter;
import com.github.houbb.property.support.converter.impl.aggregation.ShortArrayValueConverter;
import com.github.houbb.property.support.converter.impl.base.BooleanValueConverter;
import com.github.houbb.property.support.converter.impl.base.ByteValueConverter;
import com.github.houbb.property.support.converter.impl.base.CharacterValueConverter;
import com.github.houbb.property.support.converter.impl.base.DoubleValueConverter;
import com.github.houbb.property.support.converter.impl.base.EnumValueConverter;
import com.github.houbb.property.support.converter.impl.base.FloatValueConverter;
import com.github.houbb.property.support.converter.impl.base.IntegerValueConverter;
import com.github.houbb.property.support.converter.impl.base.LongValueConverter;
import com.github.houbb.property.support.converter.impl.base.ShortValueConverter;
import com.github.houbb.property.support.converter.impl.base.StringValueConverter;
import com.github.houbb.property.support.converter.impl.math.BigDecimalValueConverter;
import com.github.houbb.property.support.converter.impl.math.BigIntegerValueConverter;
import com.github.houbb.property.support.converter.impl.util.CurrencyValueConverter;
import com.github.houbb.property.support.converter.impl.util.DateValueConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;

@ThreadSafe
public class DefaultValueConverter
implements IValueConverter {
    private static final Map<Class, IValueConverter> CONVERTER_MAP = new IdentityHashMap<Class, IValueConverter>();

    @Override
    public Object fieldValue(String value, IFieldValueContext context) {
        Class<?> type = context.field().getType();
        return this.getValueConverter(type).fieldValue(value, context);
    }

    @Override
    public String propertyValue(Object value, IPropertyValueContext context) {
        Class<?> type = context.field().getType();
        return this.getValueConverter(type).propertyValue(value, context);
    }

    private IValueConverter getValueConverter(Class type) {
        ArgUtil.notNull((Object)type, (String)"type");
        IValueConverter valueConverter = CONVERTER_MAP.get(type);
        if (ObjectUtil.isNotNull((Object)valueConverter)) {
            return valueConverter;
        }
        if (ClassTypeUtil.isPrimitive((Class)type)) {
            Class actualType = PrimitiveUtil.getReferenceType((Class)type);
            return CONVERTER_MAP.get(actualType);
        }
        if (ClassTypeUtil.isArray((Class)type)) {
            return CONVERTER_MAP.get(Array.class);
        }
        if (ClassTypeUtil.isCollection((Class)type)) {
            return CONVERTER_MAP.get(Collection.class);
        }
        if (ClassTypeUtil.isEnum((Class)type)) {
            return CONVERTER_MAP.get(Enum.class);
        }
        throw new UnsupportedOperationException("Unsupported class type " + type.getName());
    }

    static {
        CONVERTER_MAP.put(BigInteger.class, new BigIntegerValueConverter());
        CONVERTER_MAP.put(BigDecimal.class, new BigDecimalValueConverter());
        CONVERTER_MAP.put(Date.class, new DateValueConverter());
        CONVERTER_MAP.put(Currency.class, new CurrencyValueConverter());
        CONVERTER_MAP.put(Boolean.class, new BooleanValueConverter());
        CONVERTER_MAP.put(Byte.class, new ByteValueConverter());
        CONVERTER_MAP.put(Character.class, new CharacterValueConverter());
        CONVERTER_MAP.put(Short.class, new ShortValueConverter());
        CONVERTER_MAP.put(Integer.class, new IntegerValueConverter());
        CONVERTER_MAP.put(Long.class, new LongValueConverter());
        CONVERTER_MAP.put(Float.class, new FloatValueConverter());
        CONVERTER_MAP.put(Double.class, new DoubleValueConverter());
        CONVERTER_MAP.put(String.class, new StringValueConverter());
        CONVERTER_MAP.put(Enum.class, new EnumValueConverter());
        CONVERTER_MAP.put(int[].class, new IntArrayValueConverter());
        CONVERTER_MAP.put(boolean[].class, new BooleanArrayValueConverter());
        CONVERTER_MAP.put(short[].class, new ShortArrayValueConverter());
        CONVERTER_MAP.put(byte[].class, new ByteArrayValueConverter());
        CONVERTER_MAP.put(long[].class, new LongArrayValueConverter());
        CONVERTER_MAP.put(char[].class, new CharArrayValueConverter());
        CONVERTER_MAP.put(float[].class, new FloatArrayValueConverter());
        CONVERTER_MAP.put(double[].class, new DoubleArrayValueConverter());
        CONVERTER_MAP.put(Array.class, new StringArrayValueConverter());
        CONVERTER_MAP.put(Collection.class, new StringCollectionValueConverter());
    }
}

