/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.TypeUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.property.exception.PropertyRuntimeException;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;

@ThreadSafe
public class StringCollectionValueConverter
implements IValueConverter {
    @Override
    public Object fieldValue(String value, IFieldValueContext context) {
        this.itemClassCheck(context.field());
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        Class<?> collectionClass = context.field().getType();
        String[] strings = StringUtil.splitToStringArray((String)value);
        Collection collection = TypeUtil.createCollection(collectionClass, (int)strings.length);
        Collections.addAll(collection, strings);
        return collection;
    }

    @Override
    public String propertyValue(Object value, IPropertyValueContext context) {
        this.itemClassCheck(context.field());
        Collection stringCollection = (Collection)value;
        return CollectionUtil.join((Collection)stringCollection);
    }

    private void itemClassCheck(Field field) {
        ArgUtil.notNull((Object)field, (String)"field");
        Type collectionType = field.getGenericType();
        Class itemClass = (Class)TypeUtil.getCollectionItemType((Type)collectionType);
        if (String.class != itemClass) {
            throw new PropertyRuntimeException("Only support for collection write item String type, but found: " + itemClass);
        }
    }
}

