/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.core.api.strategory;

import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.sensitive.api.IContext;
import com.github.houbb.sensitive.core.api.strategory.AbstractStrategy;
import com.github.houbb.sensitive.core.api.strategory.StrategyBufferThreadLocal;

public abstract class AbstractStringStrategy
extends AbstractStrategy {
    protected abstract int getBeforeMaskLen(Object var1, IContext var2, char[] var3);

    protected abstract int getAfterMaskLen(Object var1, IContext var2, char[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doDes(Object original, IContext context) {
        if (original == null) {
            return null;
        }
        String strValue = ObjectUtil.objectToString((Object)original);
        char[] chars = strValue.toCharArray();
        try {
            StringBuilder stringBuilder = StrategyBufferThreadLocal.getBuffer();
            int beforeMaskLen = this.getBeforeMaskLen(original, context, chars);
            int afterMaskLen = this.getAfterMaskLen(original, context, chars);
            int maxLen = chars.length;
            beforeMaskLen = Math.min(beforeMaskLen, maxLen);
            afterMaskLen = Math.min(afterMaskLen, maxLen);
            if (beforeMaskLen > 0) {
                stringBuilder.append(chars, 0, beforeMaskLen);
            }
            for (int i = beforeMaskLen; i < chars.length - afterMaskLen; ++i) {
                stringBuilder.append('*');
            }
            if (afterMaskLen > 0) {
                stringBuilder.append(chars, chars.length - afterMaskLen, afterMaskLen);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StrategyBufferThreadLocal.clearBuffer();
        }
    }
}

