/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.core.support.filter;

import com.alibaba.fastjson.serializer.BeanContext;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.cache.impl.ClassFieldListCache;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.Optional;
import com.github.houbb.sensitive.annotation.Sensitive;
import com.github.houbb.sensitive.api.ICondition;
import com.github.houbb.sensitive.api.IContext;
import com.github.houbb.sensitive.api.IStrategy;
import com.github.houbb.sensitive.core.api.context.SensitiveContext;
import com.github.houbb.sensitive.core.exception.SensitiveRuntimeException;
import com.github.houbb.sensitive.core.util.condition.SensitiveConditions;
import com.github.houbb.sensitive.core.util.entry.SensitiveEntryUtil;
import com.github.houbb.sensitive.core.util.strategy.SensitiveStrategyBuiltInUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@ThreadSafe
public class DefaultContextValueFilter
implements ContextValueFilter {
    private final SensitiveContext sensitiveContext;

    public DefaultContextValueFilter(SensitiveContext context) {
        this.sensitiveContext = context;
    }

    public Object process(BeanContext context, Object object, String name, Object value) {
        Object firstCollectionEntry;
        Collection entryCollection;
        Object firstArrayEntry;
        Class<?> entryFieldClass;
        Object[] arrays;
        if (ObjectUtil.isNull((Object)context)) {
            return value;
        }
        Field field = context.getField();
        Class clazz = context.getBeanClass();
        List fieldList = (List)ClassFieldListCache.getInstance().get((Object)clazz);
        this.sensitiveContext.setCurrentField(field);
        this.sensitiveContext.setCurrentObject(object);
        this.sensitiveContext.setBeanClass(clazz);
        this.sensitiveContext.setAllFieldList(fieldList);
        boolean haveSensitiveEntry = SensitiveEntryUtil.hasSensitiveEntry(field);
        if (!haveSensitiveEntry) {
            this.sensitiveContext.setEntry(value);
            return this.handleSensitive(this.sensitiveContext, field);
        }
        Class<?> fieldTypeClass = field.getType();
        if (ClassTypeUtil.isJavaBean(fieldTypeClass)) {
            return value;
        }
        if (ClassTypeUtil.isMap(fieldTypeClass)) {
            return value;
        }
        if (ClassTypeUtil.isArray(fieldTypeClass) && ArrayUtil.isNotEmpty((Object[])(arrays = (Object[])value)) && this.isBaseType(entryFieldClass = (firstArrayEntry = ArrayUtil.firstNotNullElem((Object[])arrays).get()).getClass())) {
            int arrayLength = arrays.length;
            Object newArray = Array.newInstance(entryFieldClass, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object entry = arrays[i];
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                Array.set(newArray, i, result);
            }
            return newArray;
        }
        if (ClassTypeUtil.isCollection(fieldTypeClass) && CollectionUtil.isNotEmpty((Collection)(entryCollection = (Collection)value)) && this.isBaseType((firstCollectionEntry = CollectionUtil.firstNotNullElem((Collection)entryCollection).get()).getClass())) {
            ArrayList<Object> newResultList = new ArrayList<Object>(entryCollection.size());
            for (Object entry : entryCollection) {
                this.sensitiveContext.setEntry(entry);
                Object result = this.handleSensitive(this.sensitiveContext, field);
                newResultList.add(result);
            }
            return newResultList;
        }
        return value;
    }

    private Object handleSensitive(SensitiveContext context, Field field) {
        try {
            Optional<IStrategy> strategyOptional;
            Optional<ICondition> conditionOptional;
            Class conditionClass;
            ICondition condition;
            Object originalFieldVal = context.getEntry();
            Sensitive sensitive = field.getAnnotation(Sensitive.class);
            if (ObjectUtil.isNotNull((Object)sensitive) && (condition = (ICondition)(conditionClass = sensitive.condition()).newInstance()).valid((IContext)context)) {
                Class strategyClass = sensitive.strategy();
                IStrategy strategy = (IStrategy)strategyClass.newInstance();
                this.sensitiveContext.setEntry(null);
                return strategy.des(originalFieldVal, (IContext)context);
            }
            Object[] annotations = field.getAnnotations();
            if (ArrayUtil.isNotEmpty((Object[])annotations) && ((conditionOptional = SensitiveConditions.getConditionOpt((Annotation[])annotations)).isNotPresent() || ((ICondition)conditionOptional.get()).valid((IContext)context)) && (strategyOptional = SensitiveStrategyBuiltInUtil.getStrategyOpt((Annotation[])annotations)).isPresent()) {
                this.sensitiveContext.setEntry(null);
                return ((IStrategy)strategyOptional.get()).des(originalFieldVal, (IContext)context);
            }
            this.sensitiveContext.setEntry(null);
            return originalFieldVal;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new SensitiveRuntimeException(e);
        }
    }

    private boolean isBaseType(Class fieldTypeClass) {
        if (ClassTypeUtil.isBase((Class)fieldTypeClass)) {
            return true;
        }
        return !ClassTypeUtil.isJavaBean((Class)fieldTypeClass) && !ClassTypeUtil.isArray((Class)fieldTypeClass) && !ClassTypeUtil.isCollection((Class)fieldTypeClass) && !ClassTypeUtil.isMap((Class)fieldTypeClass);
    }
}

