/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.core;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.ISensitiveWord;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordReplace;
import com.github.houbb.sensitive.word.api.IWordResult;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSensitiveWord
implements ISensitiveWord {
    protected abstract List<IWordResult> doFindAll(String var1, IWordContext var2);

    protected String doReplace(String target, List<IWordResult> allList, IWordContext context) {
        IWordReplace replace = context.wordReplace();
        StringBuilder stringBuilder = new StringBuilder();
        int startIndex = 0;
        char[] rawChars = target.toCharArray();
        for (IWordResult wordResult : allList) {
            int itemStartIx = wordResult.startIndex();
            int itemEndIx = wordResult.endIndex();
            if (startIndex < itemStartIx) {
                stringBuilder.append(rawChars, startIndex, itemStartIx - startIndex);
            }
            replace.replace(stringBuilder, rawChars, wordResult, context);
            startIndex = Math.max(startIndex, itemEndIx);
        }
        if (startIndex < rawChars.length) {
            stringBuilder.append(rawChars, startIndex, rawChars.length - startIndex);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<IWordResult> findAll(String string, IWordContext context) {
        if (StringUtil.isEmpty((String)string)) {
            return Collections.emptyList();
        }
        return this.doFindAll(string, context);
    }

    @Override
    public IWordResult findFirst(String string, IWordContext context) {
        List<IWordResult> allList = this.findAll(string, context);
        if (CollectionUtil.isNotEmpty(allList)) {
            return allList.get(0);
        }
        return null;
    }

    @Override
    public String replace(String target, IWordContext context) {
        if (StringUtil.isEmpty((String)target)) {
            return target;
        }
        List<IWordResult> allList = this.findAll(target, context);
        if (CollectionUtil.isEmpty(allList)) {
            return target;
        }
        return this.doReplace(target, allList, context);
    }

    @Override
    public boolean contains(String string, IWordContext context) {
        IWordResult firstResult = this.findFirst(string, context);
        return firstResult != null;
    }
}

