/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.support.check.AbstractWordCheck;
import java.util.Map;

@ThreadSafe
public abstract class AbstractConditionWordCheck
extends AbstractWordCheck {
    protected abstract boolean isCharCondition(char var1, int var2, InnerSensitiveWordContext var3);

    protected abstract boolean isStringCondition(int var1, StringBuilder var2, InnerSensitiveWordContext var3);

    @Override
    protected int getActualLength(int beginIndex, InnerSensitiveWordContext checkContext) {
        String txt = checkContext.originalText();
        IWordContext context = checkContext.wordContext();
        Map<Character, Character> formatCharMapping = checkContext.formatCharMapping();
        int actualLength = 0;
        StringBuilder stringBuilder = new StringBuilder();
        int currentIx = 0;
        for (int i = beginIndex; i < txt.length(); ++i) {
            currentIx = i;
            char currentChar = txt.charAt(i);
            char mappingChar = formatCharMapping.get(Character.valueOf(currentChar)).charValue();
            boolean currentCondition = this.isCharCondition(mappingChar, i, checkContext);
            if (!currentCondition) break;
            stringBuilder.append(currentChar);
        }
        if (this.isStringCondition(currentIx, stringBuilder, checkContext)) {
            actualLength = stringBuilder.length();
        }
        return actualLength;
    }
}

