/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.bs;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.ISensitiveWord;
import com.github.houbb.sensitive.word.api.ISensitiveWordCharIgnore;
import com.github.houbb.sensitive.word.api.ISensitiveWordDestroy;
import com.github.houbb.sensitive.word.api.IWordAllow;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordData;
import com.github.houbb.sensitive.word.api.IWordDeny;
import com.github.houbb.sensitive.word.api.IWordFormat;
import com.github.houbb.sensitive.word.api.IWordReplace;
import com.github.houbb.sensitive.word.api.IWordResult;
import com.github.houbb.sensitive.word.api.IWordResultCondition;
import com.github.houbb.sensitive.word.api.IWordResultHandler;
import com.github.houbb.sensitive.word.api.IWordTag;
import com.github.houbb.sensitive.word.api.combine.IWordAllowDenyCombine;
import com.github.houbb.sensitive.word.api.combine.IWordCheckCombine;
import com.github.houbb.sensitive.word.api.combine.IWordFormatCombine;
import com.github.houbb.sensitive.word.bs.SensitiveWordContext;
import com.github.houbb.sensitive.word.core.SensitiveWords;
import com.github.houbb.sensitive.word.support.allow.WordAllows;
import com.github.houbb.sensitive.word.support.check.WordChecks;
import com.github.houbb.sensitive.word.support.combine.allowdeny.WordAllowDenyCombines;
import com.github.houbb.sensitive.word.support.combine.check.WordCheckCombines;
import com.github.houbb.sensitive.word.support.combine.format.WordFormatCombines;
import com.github.houbb.sensitive.word.support.data.WordDatas;
import com.github.houbb.sensitive.word.support.deny.WordDenys;
import com.github.houbb.sensitive.word.support.ignore.SensitiveWordCharIgnores;
import com.github.houbb.sensitive.word.support.replace.WordReplaces;
import com.github.houbb.sensitive.word.support.result.WordResultHandlers;
import com.github.houbb.sensitive.word.support.resultcondition.WordResultConditions;
import com.github.houbb.sensitive.word.support.tag.WordTags;
import com.github.houbb.sensitive.word.utils.InnerWordFormatUtils;
import com.github.houbb.sensitive.word.utils.InnerWordTagUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SensitiveWordBs
implements ISensitiveWordDestroy {
    private boolean ignoreCase = true;
    private boolean ignoreWidth = true;
    private boolean ignoreNumStyle = true;
    private boolean ignoreChineseStyle = true;
    private boolean ignoreEnglishStyle = true;
    private boolean ignoreRepeat = false;
    private boolean enableNumCheck = false;
    private boolean enableEmailCheck = false;
    private boolean enableUrlCheck = false;
    private boolean enableWordCheck = true;
    private boolean enableIpv4Check = false;
    private int numCheckLen = 8;
    private ISensitiveWord sensitiveWord = SensitiveWords.defaults();
    private IWordData wordData = WordDatas.defaults();
    private IWordData wordDataAllow = WordDatas.defaults();
    private IWordDeny wordDeny = WordDenys.defaults();
    private IWordAllow wordAllow = WordAllows.defaults();
    private IWordReplace wordReplace = WordReplaces.defaults();
    private IWordContext context = SensitiveWordContext.newInstance();
    private IWordCheckCombine wordCheckCombine = WordCheckCombines.defaults();
    private IWordFormatCombine wordFormatCombine = WordFormatCombines.defaults();
    private IWordAllowDenyCombine wordAllowDenyCombine = WordAllowDenyCombines.defaults();
    private IWordTag wordTag = WordTags.defaults();
    private ISensitiveWordCharIgnore charIgnore = SensitiveWordCharIgnores.defaults();
    private IWordResultCondition wordResultCondition = WordResultConditions.alwaysTrue();
    private IWordCheck wordCheckWord = WordChecks.word();
    private IWordCheck wordCheckNum = WordChecks.num();
    private IWordCheck wordCheckEmail = WordChecks.email();
    private IWordCheck wordCheckUrl = WordChecks.url();
    private IWordCheck wordCheckIpv4 = WordChecks.ipv4();

    private SensitiveWordBs() {
    }

    public static SensitiveWordBs newInstance() {
        return new SensitiveWordBs();
    }

    public SensitiveWordBs init() {
        IWordContext context = this.initContext();
        IWordFormat charFormat = this.wordFormatCombine.initWordFormat(context);
        context.wordFormat(charFormat);
        IWordCheck sensitiveCheck = this.wordCheckCombine.initWordCheck(context);
        context.sensitiveCheck(sensitiveCheck);
        List<String> wordAllowList = this.wordAllow.allow();
        List<String> wordDenyList = this.wordDeny.deny();
        Collection<String> denyList = this.wordAllowDenyCombine.getActualDenyList(wordAllowList, wordDenyList, context);
        this.wordData.initWordData(denyList);
        List<String> actualAllowList = InnerWordFormatUtils.formatWordList(wordAllowList, context);
        this.wordDataAllow.initWordData(actualAllowList);
        context.wordData(this.wordData);
        context.wordDataAllow(this.wordDataAllow);
        this.context = context;
        return this;
    }

    private IWordContext initContext() {
        SensitiveWordContext context = SensitiveWordContext.newInstance();
        context.ignoreCase(this.ignoreCase);
        context.ignoreWidth(this.ignoreWidth);
        context.ignoreNumStyle(this.ignoreNumStyle);
        context.ignoreChineseStyle(this.ignoreChineseStyle);
        context.ignoreEnglishStyle(this.ignoreEnglishStyle);
        context.ignoreRepeat(this.ignoreRepeat);
        context.enableNumCheck(this.enableNumCheck);
        context.enableEmailCheck(this.enableEmailCheck);
        context.enableUrlCheck(this.enableUrlCheck);
        context.enableWordCheck(this.enableWordCheck);
        context.enableIpv4Check(this.enableIpv4Check);
        context.wordCheckWord(this.wordCheckWord);
        context.wordCheckEmail(this.wordCheckEmail);
        context.wordCheckNum(this.wordCheckNum);
        context.wordCheckUrl(this.wordCheckUrl);
        context.wordCheckIpv4(this.wordCheckIpv4);
        context.sensitiveCheckNumLen(this.numCheckLen);
        context.wordReplace(this.wordReplace);
        context.wordData(this.wordData);
        context.wordTag(this.wordTag);
        context.charIgnore(this.charIgnore);
        context.wordResultCondition(this.wordResultCondition);
        return context;
    }

    public SensitiveWordBs wordResultCondition(IWordResultCondition wordResultCondition) {
        ArgUtil.notNull((Object)wordResultCondition, (String)"wordResultCondition");
        this.wordResultCondition = wordResultCondition;
        return this;
    }

    public SensitiveWordBs charIgnore(ISensitiveWordCharIgnore charIgnore) {
        ArgUtil.notNull((Object)charIgnore, (String)"charIgnore");
        this.charIgnore = charIgnore;
        return this;
    }

    public SensitiveWordBs wordTag(IWordTag wordTag) {
        ArgUtil.notNull((Object)wordTag, (String)"wordTag");
        this.wordTag = wordTag;
        return this;
    }

    public SensitiveWordBs wordCheckCombine(IWordCheckCombine wordCheckCombine) {
        ArgUtil.notNull((Object)wordCheckCombine, (String)"wordCheckCombine");
        this.wordCheckCombine = wordCheckCombine;
        return this;
    }

    public SensitiveWordBs wordFormatCombine(IWordFormatCombine wordFormatCombine) {
        ArgUtil.notNull((Object)wordFormatCombine, (String)"wordFormatCombine");
        this.wordFormatCombine = wordFormatCombine;
        return this;
    }

    public SensitiveWordBs wordAllowDenyCombine(IWordAllowDenyCombine wordAllowDenyCombine) {
        ArgUtil.notNull((Object)wordAllowDenyCombine, (String)"wordAllowDenyCombine");
        this.wordAllowDenyCombine = wordAllowDenyCombine;
        return this;
    }

    public SensitiveWordBs wordData(IWordData wordData) {
        ArgUtil.notNull((Object)wordData, (String)"wordData");
        this.wordData = wordData;
        return this;
    }

    public SensitiveWordBs wordDataAllow(IWordData wordDataAllow) {
        ArgUtil.notNull((Object)wordDataAllow, (String)"wordDataAllow");
        this.wordDataAllow = wordDataAllow;
        return this;
    }

    public SensitiveWordBs sensitiveWord(ISensitiveWord sensitiveWord) {
        ArgUtil.notNull((Object)sensitiveWord, (String)"sensitiveWord");
        this.sensitiveWord = sensitiveWord;
        return this;
    }

    public SensitiveWordBs wordReplace(IWordReplace wordReplace) {
        ArgUtil.notNull((Object)wordReplace, (String)"wordReplace");
        this.wordReplace = wordReplace;
        return this;
    }

    public SensitiveWordBs wordDeny(IWordDeny wordDeny) {
        ArgUtil.notNull((Object)wordDeny, (String)"wordDeny");
        this.wordDeny = wordDeny;
        return this;
    }

    public SensitiveWordBs wordAllow(IWordAllow wordAllow) {
        ArgUtil.notNull((Object)wordAllow, (String)"wordAllow");
        this.wordAllow = wordAllow;
        return this;
    }

    public SensitiveWordBs wordCheckWord(IWordCheck wordCheckWord) {
        ArgUtil.notNull((Object)wordCheckWord, (String)"wordCheckWord");
        this.wordCheckWord = wordCheckWord;
        return this;
    }

    public SensitiveWordBs wordCheckNum(IWordCheck wordCheckNum) {
        ArgUtil.notNull((Object)wordCheckNum, (String)"wordCheckNum");
        this.wordCheckNum = wordCheckNum;
        return this;
    }

    public SensitiveWordBs wordCheckEmail(IWordCheck wordCheckEmail) {
        ArgUtil.notNull((Object)wordCheckEmail, (String)"wordCheckEmail");
        this.wordCheckEmail = wordCheckEmail;
        return this;
    }

    public SensitiveWordBs wordCheckUrl(IWordCheck wordCheckUrl) {
        ArgUtil.notNull((Object)wordCheckUrl, (String)"wordCheckUrl");
        this.wordCheckUrl = wordCheckUrl;
        return this;
    }

    public SensitiveWordBs wordCheckIpv4(IWordCheck wordCheckIpv4) {
        ArgUtil.notNull((Object)wordCheckIpv4, (String)"wordCheckIpv4");
        this.wordCheckIpv4 = wordCheckIpv4;
        return this;
    }

    public SensitiveWordBs enableIpv4Check(boolean enableIpv4Check) {
        this.enableIpv4Check = enableIpv4Check;
        return this;
    }

    public SensitiveWordBs enableWordCheck(boolean enableWordCheck) {
        this.enableWordCheck = enableWordCheck;
        return this;
    }

    public SensitiveWordBs enableNumCheck(boolean enableNumCheck) {
        this.enableNumCheck = enableNumCheck;
        return this;
    }

    public SensitiveWordBs numCheckLen(int numCheckLen) {
        this.numCheckLen = numCheckLen;
        return this;
    }

    public SensitiveWordBs enableEmailCheck(boolean enableEmailCheck) {
        this.enableEmailCheck = enableEmailCheck;
        return this;
    }

    public SensitiveWordBs enableUrlCheck(boolean enableUrlCheck) {
        this.enableUrlCheck = enableUrlCheck;
        return this;
    }

    public SensitiveWordBs ignoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public SensitiveWordBs ignoreWidth(boolean ignoreWidth) {
        this.ignoreWidth = ignoreWidth;
        return this;
    }

    public SensitiveWordBs ignoreNumStyle(boolean ignoreNumStyle) {
        this.ignoreNumStyle = ignoreNumStyle;
        return this;
    }

    public SensitiveWordBs ignoreChineseStyle(boolean ignoreChineseStyle) {
        this.ignoreChineseStyle = ignoreChineseStyle;
        return this;
    }

    public SensitiveWordBs ignoreEnglishStyle(boolean ignoreEnglishStyle) {
        this.ignoreEnglishStyle = ignoreEnglishStyle;
        return this;
    }

    public SensitiveWordBs ignoreRepeat(boolean ignoreRepeat) {
        this.ignoreRepeat = ignoreRepeat;
        return this;
    }

    public boolean contains(String target) {
        return this.sensitiveWord.contains(target, this.context);
    }

    public List<String> findAll(String target) {
        return this.findAll(target, WordResultHandlers.word());
    }

    public String findFirst(String target) {
        return this.findFirst(target, WordResultHandlers.word());
    }

    public <R> List<R> findAll(final String target, final IWordResultHandler<R> handler) {
        ArgUtil.notNull(handler, (String)"handler");
        List<IWordResult> wordResults = this.sensitiveWord.findAll(target, this.context);
        return CollectionUtil.toList(wordResults, (IHandler)new IHandler<IWordResult, R>(){

            public R handle(IWordResult wordResult) {
                return handler.handle(wordResult, SensitiveWordBs.this.context, target);
            }
        });
    }

    public <R> R findFirst(String target, IWordResultHandler<R> handler) {
        ArgUtil.notNull(handler, (String)"handler");
        IWordResult wordResult = this.sensitiveWord.findFirst(target, this.context);
        return handler.handle(wordResult, this.context, target);
    }

    public String replace(String target) {
        return this.sensitiveWord.replace(target, this.context);
    }

    public Set<String> tags(String word) {
        return InnerWordTagUtils.tags(word, this.context);
    }

    @Override
    public void destroy() {
        this.wordData.destroy();
        this.wordDataAllow.destroy();
    }

    public void removeWord(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.removeWord(wordList);
    }

    public void removeWord(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordData.removeWord(formatList);
    }

    public void addWord(Collection<String> collection) {
        List<String> formatAllowList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordData.addWord(formatAllowList);
    }

    public void addWord(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.addWord(wordList);
    }

    public void removeWordAllow(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.removeWordAllow(wordList);
    }

    public void removeWordAllow(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordDataAllow.removeWord(formatList);
    }

    public void addWordAllow(Collection<String> collection) {
        List<String> formatList = InnerWordFormatUtils.formatWordList(collection, this.context);
        this.wordDataAllow.addWord(formatList);
    }

    public void addWordAllow(String word, String ... others) {
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(word);
        wordList.addAll(Arrays.asList(others));
        this.addWordAllow(wordList);
    }
}

