/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordTypeEnum;
import com.github.houbb.sensitive.word.support.check.AbstractConditionWordCheck;
import com.github.houbb.sensitive.word.utils.InnerCharUtils;
import java.util.List;

@ThreadSafe
public class WordCheckIPV4
extends AbstractConditionWordCheck {
    private static final IWordCheck INSTANCE = new WordCheckIPV4();

    public static IWordCheck getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<? extends IWordCheck> getSensitiveCheckClass() {
        return WordCheckIPV4.class;
    }

    @Override
    protected String getType() {
        return WordTypeEnum.IPV4.getCode();
    }

    @Override
    protected boolean isCharCondition(char mappingChar, int index, InnerSensitiveWordContext checkContext) {
        return CharUtil.isNumber((char)mappingChar) || '.' == mappingChar;
    }

    @Override
    protected boolean isStringCondition(int index, StringBuilder stringBuilder, InnerSensitiveWordContext checkContext) {
        int bufferLen = stringBuilder.length();
        if (bufferLen < 7 || bufferLen > 15) {
            return false;
        }
        String string = stringBuilder.toString();
        List stringList = StringUtil.splitToList((String)string, (char)'.');
        if (stringList.size() != 4) {
            return false;
        }
        for (String numStr : stringList) {
            int integer = InnerCharUtils.parseInt(numStr);
            if (integer >= 0 && integer <= 256) continue;
            return false;
        }
        return true;
    }
}

