package com.github.houbb.sisyphus.api.context;

import com.github.houbb.sisyphus.api.core.Retry;
import com.github.houbb.sisyphus.api.support.block.RetryBlock;
import com.github.houbb.sisyphus.api.support.condition.RetryCondition;
import com.github.houbb.sisyphus.api.support.listen.RetryListen;
import com.github.houbb.sisyphus.api.support.recover.Recover;
import com.github.houbb.sisyphus.api.support.stop.RetryStop;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * 重试执行上下文
 * @author binbin.hou
 * @since 0.0.1
 */
public interface RetryContext<R>  {

    /**
     * 重试实现类
     * @return 重试
     * @since 0.0.5
     */
    Retry<R> retry();

    /**
     * 生效条件列表
     * @return 生效条件列表
     */
    RetryCondition condition();

    /**
     * 重试等待上下文
     * @return 重试等待上下文
     */
    List<RetryWaitContext<R>> waitContext();

    /**
     * 阻塞方式
     * @return 阻塞方式
     */
    RetryBlock block();

    /**
     * 停止方式
     * @return 停止方式
     */
    RetryStop stop();

    /**
     * 可执行的方法
     * @return 方法
     */
    Callable<R> callable();

    /**
     * 监听信息列表
     * @return 监听信息列表
     */
    RetryListen listen();

    /**
     * 恢复方式
     * @return 恢复方式
     */
    Recover recover();

}
