/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sisyphus.core.core;

import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.sisyphus.api.context.RetryWaitContext;
import com.github.houbb.sisyphus.api.support.wait.RetryWait;
import com.github.houbb.sisyphus.core.context.DefaultRetryWaitContext;
import com.github.houbb.sisyphus.core.support.wait.ExponentialRetryWait;
import com.github.houbb.sisyphus.core.support.wait.IncreaseRetryWait;
import com.github.houbb.sisyphus.core.support.wait.NoRetryWait;

@NotThreadSafe
public class RetryWaiter<R> {
    private Class<? extends RetryWait> retryWait = NoRetryWait.class;
    private long value = 1000L;
    private long min = 0L;
    private long max = 1800000L;
    private double factor = Double.MIN_VALUE;

    private RetryWaiter() {
    }

    public static <R> RetryWaiter<R> retryWait(Class<? extends RetryWait> retryWait) {
        RetryWaiter<R> retryWaiter = new RetryWaiter<R>();
        super.setRetryWait(retryWait);
        if (IncreaseRetryWait.class.equals(retryWait)) {
            retryWaiter.factor(2000.0);
        }
        if (ExponentialRetryWait.class.equals(retryWait)) {
            retryWaiter.factor(1.618);
        }
        return retryWaiter;
    }

    public Class<? extends RetryWait> retryWait() {
        return this.retryWait;
    }

    private RetryWaiter<R> setRetryWait(Class<? extends RetryWait> retryWait) {
        this.retryWait = retryWait;
        return this;
    }

    public long value() {
        return this.value;
    }

    public RetryWaiter<R> value(long value) {
        this.value = value;
        return this;
    }

    public long min() {
        return this.min;
    }

    public RetryWaiter<R> min(long min) {
        this.min = min;
        return this;
    }

    public long max() {
        return this.max;
    }

    public RetryWaiter<R> max(long max) {
        this.max = max;
        return this;
    }

    public double factor() {
        return this.factor;
    }

    public RetryWaiter<R> factor(double factor) {
        this.factor = factor;
        return this;
    }

    public RetryWaitContext<R> context() {
        DefaultRetryWaitContext waitContext = new DefaultRetryWaitContext();
        waitContext.factor(this.factor);
        waitContext.max(this.max);
        waitContext.min(this.min);
        waitContext.retryWait(this.retryWait);
        waitContext.value(this.value);
        return waitContext;
    }
}

