/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sisyphus.core.core;

import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.sisyphus.api.context.RetryContext;
import com.github.houbb.sisyphus.api.context.RetryWaitContext;
import com.github.houbb.sisyphus.api.core.Retry;
import com.github.houbb.sisyphus.api.support.block.RetryBlock;
import com.github.houbb.sisyphus.api.support.condition.RetryCondition;
import com.github.houbb.sisyphus.api.support.listen.RetryListen;
import com.github.houbb.sisyphus.api.support.recover.Recover;
import com.github.houbb.sisyphus.api.support.stop.RetryStop;
import com.github.houbb.sisyphus.core.context.DefaultRetryContext;
import com.github.houbb.sisyphus.core.core.RetryWaiter;
import com.github.houbb.sisyphus.core.core.retry.DefaultRetry;
import com.github.houbb.sisyphus.core.support.block.ThreadSleepRetryBlock;
import com.github.houbb.sisyphus.core.support.condition.RetryConditions;
import com.github.houbb.sisyphus.core.support.listen.NoRetryListen;
import com.github.houbb.sisyphus.core.support.recover.NoRecover;
import com.github.houbb.sisyphus.core.support.stop.MaxAttemptRetryStop;
import com.github.houbb.sisyphus.core.support.wait.NoRetryWait;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

@NotThreadSafe
public class Retryer<R>
implements Retry<R> {
    private Callable<R> callable;
    private Retry<R> retry = DefaultRetry.getInstance();
    private RetryCondition condition = RetryConditions.hasExceptionCause();
    private RetryBlock block = ThreadSleepRetryBlock.getInstance();
    private RetryStop stop = new MaxAttemptRetryStop(3);
    private RetryListen listen = NoRetryListen.getInstance();
    private Recover recover = NoRecover.getInstance();
    private List<RetryWaitContext<R>> waitContexts = Collections.singletonList(RetryWaiter.retryWait(NoRetryWait.class).context());

    public static <R> Retryer<R> newInstance() {
        return new Retryer<R>();
    }

    public Retryer<R> callable(Callable<R> callable) {
        ArgUtil.notNull(callable, (String)"callable");
        this.callable = callable;
        return this;
    }

    public Retryer<R> retry(Retry<R> retry) {
        this.retry = retry;
        return this;
    }

    public Retryer<R> condition(RetryCondition condition) {
        ArgUtil.notNull((Object)condition, (String)"condition");
        this.condition = condition;
        return this;
    }

    public Retryer<R> retryWaitContext(RetryWaitContext<R> ... retryWaitContexts) {
        ArgUtil.notEmpty((Object[])retryWaitContexts, (String)"retryWaitContexts");
        this.waitContexts = Arrays.asList(retryWaitContexts);
        return this;
    }

    public Retryer<R> maxAttempt(int maxAttempt) {
        ArgUtil.positive((int)maxAttempt, (String)"maxAttempt");
        this.stop = new MaxAttemptRetryStop(maxAttempt);
        return this;
    }

    private Retryer<R> block(RetryBlock block) {
        ArgUtil.notNull((Object)block, (String)"block");
        this.block = block;
        return this;
    }

    private Retryer<R> stop(RetryStop stop) {
        ArgUtil.notNull((Object)stop, (String)"stop");
        this.stop = stop;
        return this;
    }

    public Retryer<R> listen(RetryListen listen) {
        ArgUtil.notNull((Object)listen, (String)"listen");
        this.listen = listen;
        return this;
    }

    public Retryer<R> recover(Recover recover) {
        ArgUtil.notNull((Object)recover, (String)"recover");
        this.recover = recover;
        return this;
    }

    public RetryContext<R> context() {
        DefaultRetryContext<R> context = new DefaultRetryContext<R>();
        context.callable(this.callable).waitContext(this.waitContexts).block(this.block).stop(this.stop).condition(this.condition).listen(this.listen).recover(this.recover).retry(this.retry);
        return context;
    }

    public R retryCall() {
        RetryContext<R> context = this.context();
        return (R)this.context().retry().retryCall(context);
    }

    public R retryCall(RetryContext<R> context) {
        return (R)this.context().retry().retryCall(context);
    }
}

