/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sisyphus.core.core.retry;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.response.exception.ExceptionUtil;
import com.github.houbb.heaven.support.instance.impl.InstanceFactory;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.DateUtil;
import com.github.houbb.sisyphus.api.context.RetryContext;
import com.github.houbb.sisyphus.api.context.RetryWaitContext;
import com.github.houbb.sisyphus.api.core.Retry;
import com.github.houbb.sisyphus.api.exception.RetryException;
import com.github.houbb.sisyphus.api.model.RetryAttempt;
import com.github.houbb.sisyphus.api.model.WaitTime;
import com.github.houbb.sisyphus.api.support.block.RetryBlock;
import com.github.houbb.sisyphus.api.support.condition.RetryCondition;
import com.github.houbb.sisyphus.api.support.listen.RetryListen;
import com.github.houbb.sisyphus.api.support.recover.Recover;
import com.github.houbb.sisyphus.api.support.stop.RetryStop;
import com.github.houbb.sisyphus.api.support.wait.RetryWait;
import com.github.houbb.sisyphus.core.context.DefaultRetryWaitContext;
import com.github.houbb.sisyphus.core.model.DefaultAttemptTime;
import com.github.houbb.sisyphus.core.model.DefaultRetryAttempt;
import com.github.houbb.sisyphus.core.model.DefaultWaitTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public class DefaultRetry<R>
implements Retry<R> {
    public static DefaultRetry getInstance() {
        return (DefaultRetry)InstanceFactory.getInstance().singleton(DefaultRetry.class);
    }

    public R retryCall(RetryContext<R> context) {
        Throwable throwable;
        ArrayList<RetryAttempt<R>> history = new ArrayList<RetryAttempt<R>>();
        int attempts = 1;
        Callable callable = context.callable();
        RetryAttempt<R> retryAttempt = this.execute(callable, attempts, history);
        List waitContextList = context.waitContext();
        RetryCondition retryCondition = context.condition();
        RetryStop retryStop = context.stop();
        RetryBlock retryBlock = context.block();
        RetryListen retryListen = context.listen();
        while (retryCondition.condition(retryAttempt) && !retryStop.stop(retryAttempt)) {
            WaitTime waitTime = this.calcWaitTime(waitContextList, retryAttempt);
            retryBlock.block(waitTime);
            history.add(retryAttempt);
            retryAttempt = this.execute(callable, ++attempts, history);
            retryListen.listen(retryAttempt);
        }
        if (retryCondition.condition(retryAttempt) && retryStop.stop(retryAttempt)) {
            Recover recover = context.recover();
            recover.recover(retryAttempt);
        }
        if (ObjectUtil.isNotNull((Object)(throwable = retryAttempt.cause()))) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RetryException(retryAttempt.cause());
        }
        return (R)retryAttempt.result();
    }

    private WaitTime calcWaitTime(List<RetryWaitContext<R>> waitContextList, RetryAttempt<R> retryAttempt) {
        long totalTimeMills = 0L;
        for (RetryWaitContext<R> context : waitContextList) {
            RetryWait retryWait = (RetryWait)InstanceFactory.getInstance().threadSafe(context.retryWait());
            RetryWaitContext retryWaitContext = this.buildRetryWaitContext(context, retryAttempt);
            WaitTime waitTime = retryWait.waitTime(retryWaitContext);
            totalTimeMills += TimeUnit.MILLISECONDS.convert(waitTime.time(), waitTime.unit());
        }
        return new DefaultWaitTime(totalTimeMills);
    }

    private RetryWaitContext buildRetryWaitContext(RetryWaitContext waitContext, RetryAttempt<R> retryAttempt) {
        DefaultRetryWaitContext context = (DefaultRetryWaitContext)waitContext;
        context.attempt(retryAttempt.attempt());
        context.result(retryAttempt.result());
        context.history(retryAttempt.history());
        context.cause(retryAttempt.cause());
        context.time(retryAttempt.time());
        return context;
    }

    private RetryAttempt<R> execute(Callable<R> callable, int attempts, List<RetryAttempt<R>> history) {
        Date startTime = DateUtil.now();
        DefaultRetryAttempt retryAttempt = new DefaultRetryAttempt();
        Throwable throwable = null;
        Object result = null;
        try {
            result = callable.call();
        }
        catch (Exception e) {
            throwable = ExceptionUtil.getActualThrowable((Throwable)e);
        }
        Date endTime = DateUtil.now();
        long costTimeInMills = DateUtil.costTimeInMills((Date)startTime, (Date)endTime);
        DefaultAttemptTime attemptTime = new DefaultAttemptTime();
        attemptTime.startTime(startTime).endTime(endTime).costTimeInMills(costTimeInMills);
        retryAttempt.attempt(attempts).time(attemptTime).cause(throwable).result(result).history(history);
        return retryAttempt;
    }
}

