/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sisyphus.core.support.condition;

import com.github.houbb.heaven.support.instance.impl.InstanceFactory;
import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.sisyphus.api.model.RetryAttempt;
import com.github.houbb.sisyphus.api.support.condition.RetryCondition;
import com.github.houbb.sisyphus.core.support.condition.AbstractCauseRetryCondition;
import com.github.houbb.sisyphus.core.support.condition.AbstractResultRetryCondition;
import com.github.houbb.sisyphus.core.support.condition.AbstractRetryConditionInit;
import com.github.houbb.sisyphus.core.support.condition.AlwaysFalseRetryCondition;
import com.github.houbb.sisyphus.core.support.condition.ExceptionCauseRetryCondition;
import com.github.houbb.sisyphus.core.support.condition.NotNullResultRetryCondition;
import com.github.houbb.sisyphus.core.support.condition.NullResultRetryCondition;

public final class RetryConditions {
    private RetryConditions() {
    }

    public static <R> RetryCondition<R> isNullResult() {
        return (RetryCondition)InstanceFactory.getInstance().singleton(NullResultRetryCondition.class);
    }

    public static <R> RetryCondition<R> isNotNullResult() {
        return (RetryCondition)InstanceFactory.getInstance().singleton(NotNullResultRetryCondition.class);
    }

    public static <R> RetryCondition<R> isEqualsResult(final R excepted) {
        return new AbstractResultRetryCondition<R>(){

            @Override
            protected boolean resultCondition(R result) {
                if (ObjectUtil.isNull(result)) {
                    return false;
                }
                return result.equals(excepted);
            }
        };
    }

    public static <R> RetryCondition<R> isNotEqualsResult(final R excepted) {
        return new AbstractResultRetryCondition<R>(){

            @Override
            protected boolean resultCondition(R result) {
                if (ObjectUtil.isNull(result)) {
                    return true;
                }
                return !result.equals(excepted);
            }
        };
    }

    public static RetryCondition hasExceptionCause() {
        return (RetryCondition)InstanceFactory.getInstance().singleton(ExceptionCauseRetryCondition.class);
    }

    public static RetryCondition isExceptionCauseType(final Class<? extends Throwable> exClass) {
        return new AbstractCauseRetryCondition(){

            @Override
            protected boolean causeCondition(Throwable throwable) {
                return exClass.isAssignableFrom(throwable.getClass());
            }
        };
    }

    public static RetryCondition conditions(final RetryCondition ... retryConditions) {
        if (ArrayUtil.isEmpty((Object[])retryConditions)) {
            return AlwaysFalseRetryCondition.getInstance();
        }
        return new AbstractRetryConditionInit(){

            @Override
            protected void init(Pipeline<RetryCondition> pipeline, RetryAttempt retryAttempt) {
                for (RetryCondition retryCondition : retryConditions) {
                    pipeline.addLast((Object)retryCondition);
                }
            }
        };
    }
}

