/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.JasyncBatch;
import com.github.jasync.r2dbc.mysql.JasyncConnectionMetadata;
import com.github.jasync.r2dbc.mysql.JasyncStatement;
import com.github.jasync.sql.db.ConcreteConnection;
import com.github.jasync.sql.db.mysql.MySQLConnection;
import com.github.jasync.sql.db.mysql.pool.MySQLConnectionFactory;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J4\u0010\u0019\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00100\u0010 \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u001a0\u001a2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010&\u001a\u00020!H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u000f2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncClientConnection;", "Lio/r2dbc/spi/Connection;", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "jasyncConnection", "mySQLConnectionFactory", "Lcom/github/jasync/sql/db/mysql/pool/MySQLConnectionFactory;", "(Lcom/github/jasync/sql/db/Connection;Lcom/github/jasync/sql/db/mysql/pool/MySQLConnectionFactory;)V", "isolationLevel", "Lio/r2dbc/spi/IsolationLevel;", "assertValidSavepointName", "", "name", "", "beginTransaction", "Lorg/reactivestreams/Publisher;", "Ljava/lang/Void;", "close", "commitTransaction", "createBatch", "Lio/r2dbc/spi/Batch;", "createSavepoint", "createStatement", "Lio/r2dbc/spi/Statement;", "sql", "executeVoid", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "get", "getMetadata", "Lio/r2dbc/spi/ConnectionMetadata;", "getTransactionIsolationLevel", "isAutoCommit", "", "releaseSavepoint", "rollbackTransaction", "rollbackTransactionToSavepoint", "setAutoCommit", "autoCommit", "setTransactionIsolationLevel", "validate", "depth", "Lio/r2dbc/spi/ValidationDepth;", "jasync-r2dbc-mysql"})
public final class JasyncClientConnection
implements Connection,
Supplier<com.github.jasync.sql.db.Connection> {
    @NotNull
    private final com.github.jasync.sql.db.Connection jasyncConnection;
    @NotNull
    private final MySQLConnectionFactory mySQLConnectionFactory;
    @NotNull
    private IsolationLevel isolationLevel;

    public JasyncClientConnection(@NotNull com.github.jasync.sql.db.Connection jasyncConnection, @NotNull MySQLConnectionFactory mySQLConnectionFactory) {
        Intrinsics.checkNotNullParameter((Object)jasyncConnection, (String)"jasyncConnection");
        Intrinsics.checkNotNullParameter((Object)mySQLConnectionFactory, (String)"mySQLConnectionFactory");
        this.jasyncConnection = jasyncConnection;
        this.mySQLConnectionFactory = mySQLConnectionFactory;
        IsolationLevel isolationLevel = IsolationLevel.REPEATABLE_READ;
        Intrinsics.checkNotNullExpressionValue((Object)isolationLevel, (String)"REPEATABLE_READ");
        this.isolationLevel = isolationLevel;
    }

    @NotNull
    public Publisher<Boolean> validate(@NotNull ValidationDepth depth) {
        Publisher publisher;
        Intrinsics.checkNotNullParameter((Object)depth, (String)"depth");
        switch (WhenMappings.$EnumSwitchMapping$0[depth.ordinal()]) {
            case 1: {
                publisher = (Publisher)MonoExtensionsKt.toMono((Object)this.mySQLConnectionFactory.validate((ConcreteConnection)((MySQLConnection)this.jasyncConnection)).isSuccess());
                break;
            }
            case 2: {
                Mono mono = Mono.defer(() -> JasyncClientConnection.validate$lambda-1(this));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n                \u2026 }.toMono()\n            }");
                publisher = (Publisher)mono;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return publisher;
    }

    @NotNull
    public ConnectionMetadata getMetadata() {
        return new JasyncConnectionMetadata(this.jasyncConnection);
    }

    @NotNull
    public Publisher<Void> beginTransaction() {
        Mono<Void> mono = this.executeVoid("START TRANSACTION");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"START TRANSACTION\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> commitTransaction() {
        Mono<Void> mono = this.executeVoid("COMMIT");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"COMMIT\")");
        return (Publisher)mono;
    }

    public boolean isAutoCommit() {
        return ((MySQLConnection)this.jasyncConnection).isAutoCommit();
    }

    @NotNull
    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        Mono<Void> mono = this.executeVoid("SET AUTOCOMMIT = " + (autoCommit ? 1 : 0));
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"SET AUTOCOM\u2026 (autoCommit) 1 else 0}\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> createSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> releaseSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("RELEASE SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"RELEASE SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransactionToSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("ROLLBACK TO SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"ROLLBACK TO SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransaction() {
        Mono<Void> mono = this.executeVoid("ROLLBACK");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"ROLLBACK\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> setTransactionIsolationLevel(@NotNull IsolationLevel isolationLevel) {
        Intrinsics.checkNotNullParameter((Object)isolationLevel, (String)"isolationLevel");
        Mono mono = this.executeVoid("SET TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql()).doOnSuccess(arg_0 -> JasyncClientConnection.setTransactionIsolationLevel$lambda-2(this, isolationLevel, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"executeVoid(\"SET TRANSAC\u2026nLevel = isolationLevel }");
        return (Publisher)mono;
    }

    @NotNull
    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    @NotNull
    public Statement createStatement(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return new JasyncStatement(this, sql);
    }

    @NotNull
    public Publisher<Void> close() {
        Mono mono = Mono.defer(() -> JasyncClientConnection.close$lambda-3(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer { jasyncConnection\u2026nnect().toMono().then() }");
        return (Publisher)mono;
    }

    @NotNull
    public Batch createBatch() {
        return new JasyncBatch(this);
    }

    @Override
    @NotNull
    public com.github.jasync.sql.db.Connection get() {
        return this.jasyncConnection;
    }

    private final Mono<Void> executeVoid(String sql) {
        return Mono.defer(() -> JasyncClientConnection.executeVoid$lambda-4(this, sql));
    }

    private final void assertValidSavepointName(String name) {
        if (((CharSequence)name).length() == 0) {
            throw new IllegalArgumentException("Savepoint name is empty");
        }
        if (StringsKt.indexOf$default((CharSequence)name, (char)'`', (int)0, (boolean)false, (int)6, null) != -1) {
            throw new IllegalArgumentException("Savepoint name must not contain backticks");
        }
    }

    private static final Mono validate$lambda-1(JasyncClientConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CompletableFuture $this$map$iv = this$0.mySQLConnectionFactory.test((ConcreteConnection)((MySQLConnection)this$0.jasyncConnection));
        boolean $i$f$map = false;
        CompletionStage completionStage = $this$map$iv.thenApply(new Function(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                MySQLConnection it2 = (MySQLConnection)it;
                boolean bl = false;
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A) -> B)\u2026=\n    thenApply { f(it) }");
        return MonoExtensionsKt.toMono((CompletableFuture)completionStage);
    }

    private static final void setTransactionIsolationLevel$lambda-2(JasyncClientConnection this$0, IsolationLevel $isolationLevel, Void it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$isolationLevel, (String)"$isolationLevel");
        this$0.isolationLevel = $isolationLevel;
    }

    private static final Mono close$lambda-3(JasyncClientConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return MonoExtensionsKt.toMono((CompletableFuture)this$0.jasyncConnection.disconnect()).then();
    }

    private static final Mono executeVoid$lambda-4(JasyncClientConnection this$0, String $sql) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sql, (String)"$sql");
        return MonoExtensionsKt.toMono((CompletableFuture)this$0.jasyncConnection.sendQuery($sql)).then();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationDepth.values().length];
            nArray[ValidationDepth.LOCAL.ordinal()] = 1;
            nArray[ValidationDepth.REMOTE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

