/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.Bindings;
import com.github.jasync.r2dbc.mysql.JasyncDatabaseException;
import com.github.jasync.r2dbc.mysql.JasyncResult;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.exceptions.ConnectionTimeoutedException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.mysql.MySQLQueryResult;
import com.github.jasync.sql.db.mysql.exceptions.MySQLException;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxExtensionsKt;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00062\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019H\u0016J!\u0010\u001b\u001a\u00020\u00012\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001d\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncStatement;", "Lio/r2dbc/spi/Statement;", "clientSupplier", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "sql", "", "(Ljava/util/function/Supplier;Ljava/lang/String;)V", "bindings", "Lcom/github/jasync/r2dbc/mysql/Bindings;", "generatedKeyName", "isPrepared", "", "selectLastInsertId", "add", "bind", "index", "", "value", "", "identifier", "bindNull", "type", "Ljava/lang/Class;", "execute", "Lorg/reactivestreams/Publisher;", "Lio/r2dbc/spi/Result;", "returnGeneratedValues", "columns", "", "([Ljava/lang/String;)Lio/r2dbc/spi/Statement;", "jasync-r2dbc-mysql"})
public final class JasyncStatement
implements Statement {
    @NotNull
    private final Supplier<Connection> clientSupplier;
    @NotNull
    private final String sql;
    @NotNull
    private final Bindings bindings;
    private boolean isPrepared;
    private boolean selectLastInsertId;
    @NotNull
    private String generatedKeyName;

    public JasyncStatement(@NotNull Supplier<Connection> clientSupplier, @NotNull String sql) {
        Intrinsics.checkNotNullParameter(clientSupplier, (String)"clientSupplier");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.clientSupplier = clientSupplier;
        this.sql = sql;
        this.bindings = new Bindings();
        this.generatedKeyName = "LAST_INSERT_ID";
    }

    @NotNull
    public Statement returnGeneratedValues(String ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        if (columns.length == 1) {
            if (!(((CharSequence)columns[0]).length() > 0)) {
                boolean $i$a$-require-JasyncStatement$returnGeneratedValues$32 = false;
                String $i$a$-require-JasyncStatement$returnGeneratedValues$32 = "generated value name must not be empty";
                throw new IllegalArgumentException($i$a$-require-JasyncStatement$returnGeneratedValues$32.toString());
            }
            if (!(StringsKt.indexOf$default((CharSequence)columns[0], (char)'`', (int)0, (boolean)false, (int)6, null) < 0)) {
                boolean bl = false;
                String string = "generated value name must not contain backticks";
                throw new IllegalArgumentException(string.toString());
            }
            this.generatedKeyName = columns[0];
        }
        if (columns.length > 1) {
            throw new IllegalArgumentException("MySQL only supports a single generated value");
        }
        this.selectLastInsertId = true;
        return this;
    }

    @NotNull
    public Statement add() {
        if (this.isPrepared) {
            this.bindings.done();
        }
        return this;
    }

    @NotNull
    public Statement bind(@NotNull String identifier, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.bind(Integer.parseInt(identifier), value);
    }

    @NotNull
    public Statement bind(int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.isPrepared = true;
        Integer n = index;
        this.bindings.current().put(n, value);
        return this;
    }

    @NotNull
    public Statement bindNull(@NotNull String identifier, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.bindNull(Integer.parseInt(identifier), type);
    }

    @NotNull
    public Statement bindNull(int index, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.isPrepared = true;
        Integer n = index;
        this.bindings.current().put(n, null);
        return this;
    }

    @NotNull
    public Publisher<? extends Result> execute() {
        Flux flux = Mono.fromSupplier(this.clientSupplier).flatMapMany(arg_0 -> JasyncStatement.execute$lambda-3(this, arg_0)).map(arg_0 -> JasyncStatement.execute$lambda-4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"fromSupplier(clientSuppl\u2026          }\n            }");
        return (Publisher)FluxExtensionsKt.onErrorMap((Flux)flux, (KClass)Reflection.getOrCreateKotlinClass(Throwable.class), (Function1)((Function1)new Function1<Throwable, Throwable>(this){
            final /* synthetic */ JasyncStatement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Throwable invoke(@NotNull Throwable throwable) {
                Throwable throwable2;
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Throwable throwable3 = throwable;
                if (throwable3 instanceof ConnectionTimeoutedException) {
                    throwable2 = (Throwable)new R2dbcTimeoutException(throwable);
                } else if (throwable3 instanceof IllegalArgumentException) {
                    throwable2 = throwable;
                } else if (throwable3 instanceof IllegalStateException) {
                    throwable2 = throwable;
                } else if (throwable3 instanceof UnsupportedOperationException) {
                    throwable2 = throwable;
                } else if (throwable3 instanceof IOException) {
                    throwable2 = throwable;
                } else if (throwable3 instanceof MySQLException) {
                    ErrorMessage errorMessage = ((MySQLException)throwable).getErrorMessage();
                    throwable2 = (Throwable)(errorMessage.getErrorCode() == 1044 ? (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable) : (errorMessage.getErrorCode() == 1045 ? (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable) : (errorMessage.getErrorCode() == 1064 ? (R2dbcException)new R2dbcBadGrammarException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), JasyncStatement.access$getSql$p(this.this$0), throwable) : (R2dbcException)new JasyncDatabaseException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable))));
                } else {
                    throwable2 = throwable3 instanceof InsufficientParametersException ? (Throwable)new R2dbcDataIntegrityViolationException(throwable.getMessage(), throwable) : (Throwable)new R2dbcTimeoutException(throwable);
                }
                return throwable2;
            }
        }));
    }

    private static final Publisher execute$lambda-3$lambda-2(Connection $connection, JasyncStatement this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.sql;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return (Publisher)MonoExtensionsKt.toMono((CompletableFuture)$connection.sendPreparedStatement(string, it));
    }

    private static final Publisher execute$lambda-3(JasyncStatement this$0, Connection connection) {
        Publisher publisher;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isPrepared) {
            Flux allParams2 = FluxExtensionsKt.toFlux((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)this$0.bindings.all()), (Function2)((Function2)new Function2<Integer, Map<Integer, ? extends Object>, List<? extends Object>>(this$0){
                final /* synthetic */ JasyncStatement this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Object> invoke(int i, @NotNull Map<Integer, ? extends Object> binding) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter(binding, (String)"binding");
                    Iterable iterable = (Iterable)RangesKt.until((int)0, (int)binding.size());
                    JasyncStatement jasyncStatement = this.this$0;
                    boolean $i$f$map = false;
                    void var6_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if (!binding.containsKey((int)it)) {
                            throw new IllegalStateException("binding failed with bind index " + i + " and param index " + (int)it + " for query '" + JasyncStatement.access$getSql$p(jasyncStatement) + '\'');
                        }
                        collection.add(binding.get((int)it));
                    }
                    return (List)destination$iv$iv;
                }
            })));
            publisher = (Publisher)allParams2.concatMap(arg_0 -> JasyncStatement.execute$lambda-3$lambda-2(connection, this$0, arg_0));
        } else {
            publisher = (Publisher)MonoExtensionsKt.toMono((CompletableFuture)connection.sendQuery(this$0.sql));
        }
        return publisher;
    }

    private static final JasyncResult execute$lambda-4(JasyncStatement this$0, QueryResult it) {
        JasyncResult jasyncResult;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.selectLastInsertId) {
            QueryResult queryResult = it;
            if (queryResult == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLQueryResult");
            }
            long lastInsertId = ((MySQLQueryResult)queryResult).getLastInsertId();
            jasyncResult = new JasyncResult(it.getRows(), it.getRowsAffected(), this$0.selectLastInsertId, lastInsertId, this$0.generatedKeyName);
        } else {
            jasyncResult = new JasyncResult(it.getRows(), it.getRowsAffected());
        }
        return jasyncResult;
    }

    public static final /* synthetic */ String access$getSql$p(JasyncStatement $this) {
        return $this.sql;
    }
}

