/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

public class Trie {
    private final TrieNode root = new TrieNode();
    private boolean startWith;

    public void insert(String word) {
        this.insert(word, this.root, 0);
    }

    private void insert(String word, TrieNode root, int idx) {
        if (idx == word.length()) {
            root.isWord = true;
            return;
        }
        int index = word.charAt(idx) - 32;
        if (root.children[index] == null) {
            root.children[index] = new TrieNode();
        }
        this.insert(word, root.children[index], idx + 1);
    }

    public boolean search(String word) {
        return this.search(word, this.root, 0);
    }

    public boolean search(String word, TrieNode root, int idx) {
        if (idx == word.length()) {
            this.startWith = true;
            return root.isWord;
        }
        int index = word.charAt(idx) - 32;
        if (root.children[index] == null) {
            this.startWith = false;
            return false;
        }
        return this.search(word, root.children[index], idx + 1);
    }

    public boolean startsWith(String prefix) {
        this.search(prefix);
        return this.startWith;
    }

    public static class TrieNode {
        TrieNode[] children = new TrieNode[1071];
        boolean isWord;
    }
}

