/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.nodeTypes;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface NodeWithConstructors<N extends Node>
extends NodeWithSimpleName<N>,
NodeWithMembers<N> {
    default public Optional<ConstructorDeclaration> getDefaultConstructor() {
        return this.getMembers().stream().filter(bd -> bd instanceof ConstructorDeclaration).map(bd -> (ConstructorDeclaration)bd).filter(cd -> cd.getParameters().isEmpty()).findFirst();
    }

    default public ConstructorDeclaration addConstructor(Modifier.Keyword ... modifiers) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
        constructorDeclaration.setModifiers((NodeList)Modifier.createModifierList(modifiers));
        constructorDeclaration.setName(this.getName());
        this.getMembers().add(constructorDeclaration);
        return constructorDeclaration;
    }

    default public List<ConstructorDeclaration> getConstructors() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m -> m instanceof ConstructorDeclaration).map(m -> (ConstructorDeclaration)m).collect(Collectors.toList()));
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(String ... paramTypes) {
        return this.getConstructors().stream().filter(m -> m.hasParametersOfType(paramTypes)).findFirst();
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(Class<?> ... paramTypes) {
        return this.getConstructors().stream().filter(m -> m.hasParametersOfType(paramTypes)).findFirst();
    }
}

