/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationMemberDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ReflectionAnnotationMemberDeclaration
implements ResolvedAnnotationMemberDeclaration {
    private static Map<Class<?>, Function<Object, ? extends Expression>> valueAsExpressionConverters = new HashMap();
    private Method annotationMember;
    private TypeSolver typeSolver;

    public ReflectionAnnotationMemberDeclaration(Method annotationMember, TypeSolver typeSolver) {
        this.annotationMember = annotationMember;
        this.typeSolver = typeSolver;
    }

    public Expression getDefaultValue() {
        Object value = this.annotationMember.getDefaultValue();
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            NodeList expressions = (NodeList)Arrays.stream(values).map(this::transformDefaultValue).collect(NodeList.toNodeList());
            return new ArrayInitializerExpr(expressions);
        }
        return this.transformDefaultValue(value);
    }

    private Expression transformDefaultValue(Object value) {
        if (value instanceof Enum) {
            Class declaringClass = ((Enum)value).getDeclaringClass();
            String name = ((Enum)value).name();
            return new FieldAccessExpr((Expression)new NameExpr(declaringClass.getSimpleName()), name);
        }
        if (value instanceof Annotation) {
            Class<? extends Annotation> annotationType = ((Annotation)value).annotationType();
            Method[] declaredMethods = annotationType.getDeclaredMethods();
            NodeList pairs = (NodeList)Arrays.stream(declaredMethods).map(m -> {
                ReflectionAnnotationMemberDeclaration nestedMemberDeclaration = new ReflectionAnnotationMemberDeclaration((Method)m, this.typeSolver);
                return new MemberValuePair(m.getName(), nestedMemberDeclaration.getDefaultValue());
            }).collect(NodeList.toNodeList());
            return new NormalAnnotationExpr(new Name(annotationType.getSimpleName()), pairs);
        }
        Function<Object, ? extends Expression> fn = valueAsExpressionConverters.get(value.getClass());
        if (fn == null) {
            throw new UnsupportedOperationException(String.format("Obtaining the default value of the annotation member %s (of type %s) is not supported yet.", this.annotationMember.getName(), value.getClass().getSimpleName()));
        }
        return fn.apply(value);
    }

    public ResolvedType getType() {
        Class<?> returnType = this.annotationMember.getReturnType();
        if (returnType.isPrimitive()) {
            return ResolvedPrimitiveType.byName((String)returnType.getName());
        }
        SymbolReference rrtd = this.typeSolver.tryToSolveType(returnType.getName());
        if (rrtd.isSolved()) {
            return new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)rrtd.getCorrespondingDeclaration());
        }
        throw new UnsupportedOperationException(String.format("Obtaining the type of the annotation member %s is not supported yet.", this.annotationMember.getName()));
    }

    public String getName() {
        return this.annotationMember.getName();
    }

    static {
        valueAsExpressionConverters.put(Boolean.class, value -> new BooleanLiteralExpr(((Boolean)value).booleanValue()));
        valueAsExpressionConverters.put(Character.class, value -> new CharLiteralExpr(((Character)value).charValue()));
        valueAsExpressionConverters.put(Double.class, value -> new DoubleLiteralExpr(((Double)value).doubleValue()));
        valueAsExpressionConverters.put(Integer.class, value -> new IntegerLiteralExpr(((Integer)value).intValue()));
        valueAsExpressionConverters.put(Long.class, value -> new LongLiteralExpr(((Long)value).longValue()));
        valueAsExpressionConverters.put(String.class, value -> new StringLiteralExpr((String)value));
        valueAsExpressionConverters.put(Class.class, value -> {
            ClassOrInterfaceType type = new ClassOrInterfaceType(null, ((Class)value).getSimpleName());
            return new ClassExpr((Type)type);
        });
    }
}

