/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.reflectionmodel;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedEnumDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.core.resolution.Context;
import com.github.javaparser.symbolsolver.logic.AbstractTypeDeclaration;
import com.github.javaparser.symbolsolver.logic.ConfilictingGenericTypesException;
import com.github.javaparser.symbolsolver.logic.InferenceContext;
import com.github.javaparser.symbolsolver.logic.ObjectProvider;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.symbolsolver.reflectionmodel.MyObjectProvider;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionClassAdapter;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionEnumConstantDeclaration;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionMethodResolutionLogic;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReflectionEnumDeclaration
extends AbstractTypeDeclaration
implements ResolvedEnumDeclaration {
    private Class<?> clazz;
    private TypeSolver typeSolver;
    private ReflectionClassAdapter reflectionClassAdapter;

    public ReflectionEnumDeclaration(Class<?> clazz, TypeSolver typeSolver) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class should not be null");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Class should not be an interface");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Class should not represent a primitive class");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Class should not be an array");
        }
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException("Class should be an enum");
        }
        this.clazz = clazz;
        this.typeSolver = typeSolver;
        this.reflectionClassAdapter = new ReflectionClassAdapter(clazz, typeSolver, (ResolvedReferenceTypeDeclaration)this);
    }

    public AccessSpecifier accessSpecifier() {
        return ReflectionFactory.modifiersToAccessLevel(this.clazz.getModifiers());
    }

    public Optional<ResolvedReferenceTypeDeclaration> containerType() {
        return this.reflectionClassAdapter.containerType();
    }

    public String getPackageName() {
        if (this.clazz.getPackage() != null) {
            return this.clazz.getPackage().getName();
        }
        return null;
    }

    public String getClassName() {
        String canonicalName = this.clazz.getCanonicalName();
        if (canonicalName != null && this.getPackageName() != null) {
            return canonicalName.substring(this.getPackageName().length() + 1, canonicalName.length());
        }
        return null;
    }

    public String getQualifiedName() {
        return this.clazz.getCanonicalName();
    }

    public List<ResolvedReferenceType> getAncestors() {
        return this.reflectionClassAdapter.getAncestors();
    }

    public ResolvedFieldDeclaration getField(String name) {
        return this.reflectionClassAdapter.getField(name);
    }

    public boolean hasField(String name) {
        return this.reflectionClassAdapter.hasField(name);
    }

    public List<ResolvedFieldDeclaration> getAllFields() {
        return this.reflectionClassAdapter.getAllFields();
    }

    public Set<ResolvedMethodDeclaration> getDeclaredMethods() {
        return this.reflectionClassAdapter.getDeclaredMethods();
    }

    public boolean isAssignableBy(ResolvedType type) {
        return this.reflectionClassAdapter.isAssignableBy(type);
    }

    public boolean isAssignableBy(ResolvedReferenceTypeDeclaration other) {
        return this.isAssignableBy((ResolvedType)new ReferenceTypeImpl(other, this.typeSolver));
    }

    public boolean hasDirectlyAnnotation(String qualifiedName) {
        return this.reflectionClassAdapter.hasDirectlyAnnotation(qualifiedName);
    }

    public String getName() {
        return this.clazz.getSimpleName();
    }

    public List<ResolvedTypeParameterDeclaration> getTypeParameters() {
        return this.reflectionClassAdapter.getTypeParameters();
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> parameterTypes, boolean staticOnly) {
        return ReflectionMethodResolutionLogic.solveMethod(name, parameterTypes, staticOnly, this.typeSolver, (ResolvedReferenceTypeDeclaration)this, this.clazz);
    }

    public Optional<MethodUsage> solveMethodAsUsage(String name, List<ResolvedType> parameterTypes, TypeSolver typeSolver, Context invokationContext, List<ResolvedType> typeParameterValues) {
        Optional<MethodUsage> res = ReflectionMethodResolutionLogic.solveMethodAsUsage(name, parameterTypes, typeSolver, invokationContext, typeParameterValues, (ResolvedReferenceTypeDeclaration)this, this.clazz);
        if (res.isPresent()) {
            InferenceContext inferenceContext = new InferenceContext((ObjectProvider)MyObjectProvider.INSTANCE);
            MethodUsage methodUsage = res.get();
            int i = 0;
            LinkedList<ResolvedType> parameters = new LinkedList<ResolvedType>();
            for (ResolvedType actualType : parameterTypes) {
                ResolvedType formalType = methodUsage.getParamType(i);
                parameters.add(inferenceContext.addPair(formalType, actualType));
                ++i;
            }
            try {
                ResolvedType returnType = inferenceContext.addSingle(methodUsage.returnType());
                for (int j = 0; j < parameters.size(); ++j) {
                    methodUsage = methodUsage.replaceParamType(j, inferenceContext.resolve((ResolvedType)parameters.get(j)));
                }
                methodUsage = methodUsage.replaceReturnType(inferenceContext.resolve(returnType));
                return Optional.of(methodUsage);
            }
            catch (ConfilictingGenericTypesException e) {
                return Optional.empty();
            }
        }
        return res;
    }

    public List<ResolvedEnumConstantDeclaration> getEnumConstants() {
        return Arrays.stream(this.clazz.getFields()).filter(f -> f.isEnumConstant()).map(c -> new ReflectionEnumConstantDeclaration((Field)c, this.typeSolver)).collect(Collectors.toList());
    }
}

