/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.Archive;
import com.github.junrar.ExtractDestination;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFolderExtractor
implements ExtractDestination {
    private File folderDestination;
    private static Log logger = LogFactory.getLog((String)LocalFolderExtractor.class.getName());

    public LocalFolderExtractor(File destination) {
        this.folderDestination = destination;
    }

    @Override
    public void createDirectory(FileHeader fh) {
        File f = null;
        if (fh.isDirectory() && fh.isUnicode()) {
            f = new File(this.folderDestination, fh.getFileNameW());
            if (!f.exists()) {
                this.makeDirectory(this.folderDestination, fh.getFileNameW());
            }
        } else if (fh.isDirectory() && !fh.isUnicode() && !(f = new File(this.folderDestination, fh.getFileNameString())).exists()) {
            this.makeDirectory(this.folderDestination, fh.getFileNameString());
        }
    }

    @Override
    public void extract(Archive arch, FileHeader fileHeader) throws FileNotFoundException, RarException, IOException {
        File f = this.createFile(fileHeader, this.folderDestination);
        FileOutputStream stream = new FileOutputStream(f);
        arch.extractFile(fileHeader, stream);
        ((OutputStream)stream).close();
    }

    private void makeDirectory(File destination, String fileName) {
        String[] dirs = fileName.split("\\\\");
        if (dirs == null) {
            return;
        }
        String path = "";
        for (String dir : dirs) {
            path = path + File.separator + dir;
            new File(destination, path).mkdir();
        }
    }

    private File createFile(FileHeader fh, File destination) {
        File f = null;
        String name = null;
        name = fh.isFileHeader() && fh.isUnicode() ? fh.getFileNameW() : fh.getFileNameString();
        f = new File(destination, name);
        if (!f.exists()) {
            try {
                f = this.makeFile(destination, name);
            }
            catch (IOException e) {
                logger.error((Object)("error creating the new file: " + f.getName()), (Throwable)e);
            }
        }
        return f;
    }

    private File makeFile(File destination, String name) throws IOException {
        String[] dirs = name.split("\\\\");
        if (dirs == null) {
            return null;
        }
        String path = "";
        int size = dirs.length;
        if (size == 1) {
            return new File(destination, name);
        }
        if (size > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                path = path + File.separator + dirs[i];
                new File(destination, path).mkdir();
            }
            path = path + File.separator + dirs[dirs.length - 1];
            File f = new File(destination, path);
            f.createNewFile();
            return f;
        }
        return null;
    }
}

