/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.impl;

import com.github.junrar.Archive;
import com.github.junrar.Volume;
import com.github.junrar.VolumeManager;
import com.github.junrar.impl.FileVolume;
import com.github.junrar.util.VolumeHelper;
import java.io.File;

public class FileVolumeManager
implements VolumeManager {
    private final File firstVolume;

    public FileVolumeManager(File firstVolume) {
        this.firstVolume = firstVolume;
    }

    @Override
    public Volume nextArchive(Archive archive, Volume last) {
        if (last == null) {
            return new FileVolume(archive, this.firstVolume);
        }
        FileVolume lastFileVolume = (FileVolume)last;
        boolean oldNumbering = !archive.getMainHeader().isNewNumbering() || archive.isOldFormat();
        String nextName = VolumeHelper.nextVolumeName(lastFileVolume.getFile().getAbsolutePath(), oldNumbering);
        File nextVolume = new File(nextName);
        return new FileVolume(archive, nextVolume);
    }
}

