/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

public class FileNameDecoder {
    public static int getChar(byte[] name, int pos) {
        return name[pos] & 0xFF;
    }

    public static String decode(byte[] name, int encPos) {
        int decPos = 0;
        int flags = 0;
        int flagBits = 0;
        int low = 0;
        int high = 0;
        int highByte = FileNameDecoder.getChar(name, encPos++);
        StringBuffer buf = new StringBuffer();
        while (encPos < name.length) {
            if (flagBits == 0) {
                flags = FileNameDecoder.getChar(name, encPos++);
                flagBits = 8;
            }
            switch (flags >> 6) {
                case 0: {
                    buf.append((char)FileNameDecoder.getChar(name, encPos++));
                    ++decPos;
                    break;
                }
                case 1: {
                    buf.append((char)(FileNameDecoder.getChar(name, encPos++) + (highByte << 8)));
                    ++decPos;
                    break;
                }
                case 2: {
                    low = FileNameDecoder.getChar(name, encPos);
                    high = FileNameDecoder.getChar(name, encPos + 1);
                    buf.append((char)((high << 8) + low));
                    ++decPos;
                    encPos += 2;
                    break;
                }
                case 3: {
                    int length = FileNameDecoder.getChar(name, encPos++);
                    if ((length & 0x80) != 0) {
                        int correction = FileNameDecoder.getChar(name, encPos++);
                        for (length = (length & 0x7F) + 2; length > 0 && decPos < name.length; --length, ++decPos) {
                            low = FileNameDecoder.getChar(name, decPos) + correction & 0xFF;
                            buf.append((char)((highByte << 8) + low));
                        }
                    } else {
                        length += 2;
                        while (length > 0 && decPos < name.length) {
                            buf.append((char)FileNameDecoder.getChar(name, decPos));
                            --length;
                            ++decPos;
                        }
                    }
                    break;
                }
            }
            flags = flags << 2 & 0xFF;
            flagBits -= 2;
        }
        return buf.toString();
    }
}

