/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;
import com.github.junrar.rarfile.RARVersion;
import com.github.junrar.rarfile.UnrarHeadertype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkHeader
extends BaseBlock {
    private Logger logger = LoggerFactory.getLogger((String)MarkHeader.class.getName());
    private RARVersion version;

    public MarkHeader(BaseBlock bb) {
        super(bb);
    }

    public boolean isValid() {
        if (this.getHeadCRC() != 24914) {
            return false;
        }
        if (this.getHeaderType() != UnrarHeadertype.MarkHeader) {
            return false;
        }
        if (this.getFlags() != 6689) {
            return false;
        }
        return this.getHeaderSize() == 7;
    }

    public boolean isSignature() {
        byte[] d = new byte[7];
        Raw.writeShortLittleEndian(d, 0, this.headCRC);
        d[2] = this.headerType;
        Raw.writeShortLittleEndian(d, 3, this.flags);
        Raw.writeShortLittleEndian(d, 5, this.headerSize);
        if (d[0] == 82) {
            if (d[1] == 69 && d[2] == 126 && d[3] == 94) {
                this.version = RARVersion.OLD;
            } else if (d[1] == 97 && d[2] == 114 && d[3] == 33 && d[4] == 26 && d[5] == 7) {
                if (d[6] == 0) {
                    this.version = RARVersion.V4;
                } else if (d[6] == 1) {
                    this.version = RARVersion.V5;
                }
            }
        }
        return this.version == RARVersion.OLD || this.version == RARVersion.V4;
    }

    public boolean isOldFormat() {
        return RARVersion.isOldFormat(this.version);
    }

    public RARVersion getVersion() {
        return this.version;
    }

    @Override
    public void print() {
        super.print();
        this.logger.info("valid: " + this.isValid());
    }
}

