/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.unpack.ppm;

import com.github.junrar.exception.RarException;
import com.github.junrar.unpack.Unpack;
import com.github.junrar.unpack.ppm.PPMContext;
import com.github.junrar.unpack.ppm.RangeCoder;
import com.github.junrar.unpack.ppm.SEE2Context;
import com.github.junrar.unpack.ppm.State;
import com.github.junrar.unpack.ppm.StateRef;
import com.github.junrar.unpack.ppm.SubAllocator;
import java.io.IOException;
import java.util.Arrays;

public class ModelPPM {
    public static final int MAX_O = 64;
    public static final int INT_BITS = 7;
    public static final int PERIOD_BITS = 7;
    public static final int TOT_BITS = 14;
    public static final int INTERVAL = 128;
    public static final int BIN_SCALE = 16384;
    public static final int MAX_FREQ = 124;
    private SEE2Context[][] SEE2Cont = new SEE2Context[25][16];
    private SEE2Context dummySEE2Cont;
    private PPMContext minContext = null;
    private PPMContext maxContext = null;
    private State foundState;
    private int numMasked;
    private int initEsc;
    private int orderFall;
    private int maxOrder;
    private int runLength;
    private int initRL;
    private int[] charMask = new int[256];
    private int[] NS2Indx = new int[256];
    private int[] NS2BSIndx = new int[256];
    private int[] HB2Flag = new int[256];
    private int escCount;
    private int prevSuccess;
    private int hiBitsFlag;
    private int[][] binSumm = new int[128][64];
    private RangeCoder coder = new RangeCoder();
    private SubAllocator subAlloc = new SubAllocator();
    private static int[] InitBinEsc = new int[]{15581, 7999, 22975, 18675, 25761, 23228, 26162, 24657};
    private final State tempState1 = new State(null);
    private final State tempState2 = new State(null);
    private final State tempState3 = new State(null);
    private final State tempState4 = new State(null);
    private final StateRef tempStateRef1 = new StateRef();
    private final StateRef tempStateRef2 = new StateRef();
    private final PPMContext tempPPMContext1 = new PPMContext(null);
    private final PPMContext tempPPMContext2 = new PPMContext(null);
    private final PPMContext tempPPMContext3 = new PPMContext(null);
    private final PPMContext tempPPMContext4 = new PPMContext(null);
    private final int[] ps = new int[64];

    public SubAllocator getSubAlloc() {
        return this.subAlloc;
    }

    private void restartModelRare() {
        int k;
        int i;
        Arrays.fill(this.charMask, 0);
        this.subAlloc.initSubAllocator();
        this.initRL = -(this.maxOrder < 12 ? this.maxOrder : 12) - 1;
        int addr = this.subAlloc.allocContext();
        this.minContext.setAddress(addr);
        this.maxContext.setAddress(addr);
        this.minContext.setSuffix(0);
        this.orderFall = this.maxOrder;
        this.minContext.setNumStats(256);
        this.minContext.getFreqData().setSummFreq(this.minContext.getNumStats() + 1);
        addr = this.subAlloc.allocUnits(128);
        this.foundState.setAddress(addr);
        this.minContext.getFreqData().setStats(addr);
        State state = new State(this.subAlloc.getHeap());
        addr = this.minContext.getFreqData().getStats();
        this.runLength = this.initRL;
        this.prevSuccess = 0;
        for (i = 0; i < 256; ++i) {
            state.setAddress(addr + i * 6);
            state.setSymbol(i);
            state.setFreq(1);
            state.setSuccessor(0);
        }
        for (i = 0; i < 128; ++i) {
            for (k = 0; k < 8; ++k) {
                for (int m = 0; m < 64; m += 8) {
                    this.binSumm[i][k + m] = 16384 - InitBinEsc[k] / (i + 2);
                }
            }
        }
        for (i = 0; i < 25; ++i) {
            for (k = 0; k < 16; ++k) {
                this.SEE2Cont[i][k].init(5 * i + 10);
            }
        }
    }

    private void startModelRare(int MaxOrder) {
        int i;
        int j;
        this.escCount = 1;
        this.maxOrder = MaxOrder;
        this.restartModelRare();
        this.NS2BSIndx[0] = 0;
        this.NS2BSIndx[1] = 2;
        for (j = 0; j < 9; ++j) {
            this.NS2BSIndx[2 + j] = 4;
        }
        for (j = 0; j < 245; ++j) {
            this.NS2BSIndx[11 + j] = 6;
        }
        for (i = 0; i < 3; ++i) {
            this.NS2Indx[i] = i;
        }
        int m = i;
        int k = 1;
        int Step = 1;
        while (i < 256) {
            this.NS2Indx[i] = m++;
            if (--k == 0) {
                k = ++Step;
            }
            ++i;
        }
        for (j = 0; j < 64; ++j) {
            this.HB2Flag[j] = 0;
        }
        for (j = 0; j < 192; ++j) {
            this.HB2Flag[64 + j] = 8;
        }
        this.dummySEE2Cont.setShift(7);
    }

    private void clearMask() {
        this.escCount = 1;
        Arrays.fill(this.charMask, 0);
    }

    public boolean decodeInit(Unpack unpackRead, int escChar) throws IOException, RarException {
        int MaxOrder = unpackRead.getChar() & 0xFF;
        boolean reset = (MaxOrder & 0x20) != 0;
        int MaxMB = 0;
        if (reset) {
            MaxMB = unpackRead.getChar();
            boolean MaxMBLimit = true;
            if (MaxMB > 1) {
                MaxMB = 1;
            }
        } else if (this.subAlloc.GetAllocatedMemory() == 0) {
            return false;
        }
        if ((MaxOrder & 0x40) != 0) {
            escChar = unpackRead.getChar();
            unpackRead.setPpmEscChar(escChar);
        }
        this.coder.initDecoder(unpackRead);
        if (reset) {
            if ((MaxOrder = (MaxOrder & 0x1F) + 1) > 16) {
                MaxOrder = 16 + (MaxOrder - 16) * 3;
            }
            if (MaxOrder == 1) {
                this.subAlloc.stopSubAllocator();
                return false;
            }
            this.subAlloc.startSubAllocator(MaxMB + 1);
            this.minContext = new PPMContext(this.getHeap());
            this.maxContext = new PPMContext(this.getHeap());
            this.foundState = new State(this.getHeap());
            this.dummySEE2Cont = new SEE2Context();
            for (int i = 0; i < 25; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.SEE2Cont[i][j] = new SEE2Context();
                }
            }
            this.startModelRare(MaxOrder);
        }
        return this.minContext.getAddress() != 0;
    }

    public int decodeChar() throws IOException, RarException {
        if (this.minContext.getAddress() <= this.subAlloc.getPText() || this.minContext.getAddress() > this.subAlloc.getHeapEnd()) {
            return -1;
        }
        if (this.minContext.getNumStats() != 1) {
            if (this.minContext.getFreqData().getStats() <= this.subAlloc.getPText() || this.minContext.getFreqData().getStats() > this.subAlloc.getHeapEnd()) {
                return -1;
            }
            if (!this.minContext.decodeSymbol1(this)) {
                return -1;
            }
        } else {
            this.minContext.decodeBinSymbol(this);
        }
        this.coder.decode();
        while (this.foundState.getAddress() == 0) {
            this.coder.ariDecNormalize();
            do {
                ++this.orderFall;
                this.minContext.setAddress(this.minContext.getSuffix());
                if (this.minContext.getAddress() > this.subAlloc.getPText() && this.minContext.getAddress() <= this.subAlloc.getHeapEnd()) continue;
                return -1;
            } while (this.minContext.getNumStats() == this.numMasked);
            if (!this.minContext.decodeSymbol2(this)) {
                return -1;
            }
            this.coder.decode();
        }
        int Symbol = this.foundState.getSymbol();
        if (this.orderFall == 0 && this.foundState.getSuccessor() > this.subAlloc.getPText()) {
            int addr = this.foundState.getSuccessor();
            this.minContext.setAddress(addr);
            this.maxContext.setAddress(addr);
        } else {
            this.updateModel();
            if (this.escCount == 0) {
                this.clearMask();
            }
        }
        this.coder.ariDecNormalize();
        return Symbol;
    }

    public SEE2Context[][] getSEE2Cont() {
        return this.SEE2Cont;
    }

    public SEE2Context getDummySEE2Cont() {
        return this.dummySEE2Cont;
    }

    public int getInitRL() {
        return this.initRL;
    }

    public void setEscCount(int escCount) {
        this.escCount = escCount & 0xFF;
    }

    public int getEscCount() {
        return this.escCount;
    }

    public void incEscCount(int dEscCount) {
        this.setEscCount(this.getEscCount() + dEscCount);
    }

    public int[] getCharMask() {
        return this.charMask;
    }

    public int getNumMasked() {
        return this.numMasked;
    }

    public void setNumMasked(int numMasked) {
        this.numMasked = numMasked;
    }

    public void setPrevSuccess(int prevSuccess) {
        this.prevSuccess = prevSuccess & 0xFF;
    }

    public int getInitEsc() {
        return this.initEsc;
    }

    public void setInitEsc(int initEsc) {
        this.initEsc = initEsc;
    }

    public void setRunLength(int runLength) {
        this.runLength = runLength;
    }

    public int getRunLength() {
        return this.runLength;
    }

    public void incRunLength(int dRunLength) {
        this.setRunLength(this.getRunLength() + dRunLength);
    }

    public int getPrevSuccess() {
        return this.prevSuccess;
    }

    public int getHiBitsFlag() {
        return this.hiBitsFlag;
    }

    public void setHiBitsFlag(int hiBitsFlag) {
        this.hiBitsFlag = hiBitsFlag & 0xFF;
    }

    public int[][] getBinSumm() {
        return this.binSumm;
    }

    public RangeCoder getCoder() {
        return this.coder;
    }

    public int[] getHB2Flag() {
        return this.HB2Flag;
    }

    public int[] getNS2BSIndx() {
        return this.NS2BSIndx;
    }

    public int[] getNS2Indx() {
        return this.NS2Indx;
    }

    public State getFoundState() {
        return this.foundState;
    }

    public byte[] getHeap() {
        return this.subAlloc.getHeap();
    }

    public int getOrderFall() {
        return this.orderFall;
    }

    private int createSuccessors(boolean Skip, State p1) {
        StateRef upState = this.tempStateRef2;
        State tempState = this.tempState1.init(this.getHeap());
        PPMContext pc = this.tempPPMContext1.init(this.getHeap());
        pc.setAddress(this.minContext.getAddress());
        PPMContext upBranch = this.tempPPMContext2.init(this.getHeap());
        upBranch.setAddress(this.foundState.getSuccessor());
        State p = this.tempState2.init(this.getHeap());
        int pps = 0;
        boolean noLoop = false;
        if (!Skip) {
            this.ps[pps++] = this.foundState.getAddress();
            if (pc.getSuffix() == 0) {
                noLoop = true;
            }
        }
        if (!noLoop) {
            boolean loopEntry = false;
            if (p1.getAddress() != 0) {
                p.setAddress(p1.getAddress());
                pc.setAddress(pc.getSuffix());
                loopEntry = true;
            }
            do {
                if (!loopEntry) {
                    pc.setAddress(pc.getSuffix());
                    if (pc.getNumStats() != 1) {
                        p.setAddress(pc.getFreqData().getStats());
                        if (p.getSymbol() != this.foundState.getSymbol()) {
                            do {
                                p.incAddress();
                            } while (p.getSymbol() != this.foundState.getSymbol());
                        }
                    } else {
                        p.setAddress(pc.getOneState().getAddress());
                    }
                }
                loopEntry = false;
                if (p.getSuccessor() != upBranch.getAddress()) {
                    pc.setAddress(p.getSuccessor());
                    break;
                }
                this.ps[pps++] = p.getAddress();
            } while (pc.getSuffix() != 0);
        }
        if (pps == 0) {
            return pc.getAddress();
        }
        upState.setSymbol(this.getHeap()[upBranch.getAddress()]);
        upState.setSuccessor(upBranch.getAddress() + 1);
        if (pc.getNumStats() != 1) {
            int s0;
            int cf;
            if (pc.getAddress() <= this.subAlloc.getPText()) {
                return 0;
            }
            p.setAddress(pc.getFreqData().getStats());
            if (p.getSymbol() != upState.getSymbol()) {
                do {
                    p.incAddress();
                } while (p.getSymbol() != upState.getSymbol());
            }
            upState.setFreq(1 + (2 * (cf = p.getFreq() - 1) <= (s0 = pc.getFreqData().getSummFreq() - pc.getNumStats() - cf) ? (5 * cf > s0 ? 1 : 0) : (2 * cf + 3 * s0 - 1) / (2 * s0)));
        } else {
            upState.setFreq(pc.getOneState().getFreq());
        }
        do {
            tempState.setAddress(this.ps[--pps]);
            pc.setAddress(pc.createChild(this, tempState, upState));
            if (pc.getAddress() != 0) continue;
            return 0;
        } while (pps != 0);
        return pc.getAddress();
    }

    private void updateModelRestart() {
        this.restartModelRare();
        this.escCount = 0;
    }

    private void updateModel() {
        StateRef fs = this.tempStateRef1;
        fs.setValues(this.foundState);
        State p = this.tempState3.init(this.getHeap());
        State tempState = this.tempState4.init(this.getHeap());
        PPMContext pc = this.tempPPMContext3.init(this.getHeap());
        PPMContext successor = this.tempPPMContext4.init(this.getHeap());
        pc.setAddress(this.minContext.getSuffix());
        if (fs.getFreq() < 31 && pc.getAddress() != 0) {
            if (pc.getNumStats() != 1) {
                p.setAddress(pc.getFreqData().getStats());
                if (p.getSymbol() != fs.getSymbol()) {
                    do {
                        p.incAddress();
                    } while (p.getSymbol() != fs.getSymbol());
                    tempState.setAddress(p.getAddress() - 6);
                    if (p.getFreq() >= tempState.getFreq()) {
                        State.ppmdSwap(p, tempState);
                        p.decAddress();
                    }
                }
                if (p.getFreq() < 115) {
                    p.incFreq(2);
                    pc.getFreqData().incSummFreq(2);
                }
            } else {
                p.setAddress(pc.getOneState().getAddress());
                if (p.getFreq() < 32) {
                    p.incFreq(1);
                }
            }
        }
        if (this.orderFall == 0) {
            this.foundState.setSuccessor(this.createSuccessors(true, p));
            this.minContext.setAddress(this.foundState.getSuccessor());
            this.maxContext.setAddress(this.foundState.getSuccessor());
            if (this.minContext.getAddress() == 0) {
                this.updateModelRestart();
                return;
            }
            return;
        }
        this.subAlloc.getHeap()[this.subAlloc.getPText()] = (byte)fs.getSymbol();
        this.subAlloc.incPText();
        successor.setAddress(this.subAlloc.getPText());
        if (this.subAlloc.getPText() >= this.subAlloc.getFakeUnitsStart()) {
            this.updateModelRestart();
            return;
        }
        if (fs.getSuccessor() != 0) {
            if (fs.getSuccessor() <= this.subAlloc.getPText()) {
                fs.setSuccessor(this.createSuccessors(false, p));
                if (fs.getSuccessor() == 0) {
                    this.updateModelRestart();
                    return;
                }
            }
            if (--this.orderFall == 0) {
                successor.setAddress(fs.getSuccessor());
                if (this.maxContext.getAddress() != this.minContext.getAddress()) {
                    this.subAlloc.decPText(1);
                }
            }
        } else {
            this.foundState.setSuccessor(successor.getAddress());
            fs.setSuccessor(this.minContext);
        }
        int ns = this.minContext.getNumStats();
        int s0 = this.minContext.getFreqData().getSummFreq() - ns - (fs.getFreq() - 1);
        pc.setAddress(this.maxContext.getAddress());
        while (pc.getAddress() != this.minContext.getAddress()) {
            int ns1 = pc.getNumStats();
            if (ns1 != 1) {
                if ((ns1 & 1) == 0) {
                    pc.getFreqData().setStats(this.subAlloc.expandUnits(pc.getFreqData().getStats(), ns1 >>> 1));
                    if (pc.getFreqData().getStats() == 0) {
                        this.updateModelRestart();
                        return;
                    }
                }
                int sum = (2 * ns1 < ns ? 1 : 0) + 2 * ((4 * ns1 <= ns ? 1 : 0) & (pc.getFreqData().getSummFreq() <= 8 * ns1 ? 1 : 0));
                pc.getFreqData().incSummFreq(sum);
            } else {
                p.setAddress(this.subAlloc.allocUnits(1));
                if (p.getAddress() == 0) {
                    this.updateModelRestart();
                    return;
                }
                p.setValues(pc.getOneState());
                pc.getFreqData().setStats(p);
                if (p.getFreq() < 30) {
                    p.incFreq(p.getFreq());
                } else {
                    p.setFreq(120);
                }
                pc.getFreqData().setSummFreq(p.getFreq() + this.initEsc + (ns > 3 ? 1 : 0));
            }
            int cf = 2 * fs.getFreq() * (pc.getFreqData().getSummFreq() + 6);
            int sf = s0 + pc.getFreqData().getSummFreq();
            if (cf < 6 * sf) {
                cf = 1 + (cf > sf ? 1 : 0) + (cf >= 4 * sf ? 1 : 0);
                pc.getFreqData().incSummFreq(3);
            } else {
                cf = 4 + (cf >= 9 * sf ? 1 : 0) + (cf >= 12 * sf ? 1 : 0) + (cf >= 15 * sf ? 1 : 0);
                pc.getFreqData().incSummFreq(cf);
            }
            p.setAddress(pc.getFreqData().getStats() + ns1 * 6);
            p.setSuccessor(successor);
            p.setSymbol(fs.getSymbol());
            p.setFreq(cf);
            pc.setNumStats(++ns1);
            pc.setAddress(pc.getSuffix());
        }
        int address = fs.getSuccessor();
        this.maxContext.setAddress(address);
        this.minContext.setAddress(address);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ModelPPM[");
        buffer.append("\n  numMasked=");
        buffer.append(this.numMasked);
        buffer.append("\n  initEsc=");
        buffer.append(this.initEsc);
        buffer.append("\n  orderFall=");
        buffer.append(this.orderFall);
        buffer.append("\n  maxOrder=");
        buffer.append(this.maxOrder);
        buffer.append("\n  runLength=");
        buffer.append(this.runLength);
        buffer.append("\n  initRL=");
        buffer.append(this.initRL);
        buffer.append("\n  escCount=");
        buffer.append(this.escCount);
        buffer.append("\n  prevSuccess=");
        buffer.append(this.prevSuccess);
        buffer.append("\n  foundState=");
        buffer.append(this.foundState);
        buffer.append("\n  coder=");
        buffer.append(this.coder);
        buffer.append("\n  subAlloc=");
        buffer.append(this.subAlloc);
        buffer.append("\n]");
        return buffer.toString();
    }
}

