/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.datahandle;

import com.kmood.datahandle.Config;
import com.kmood.datahandle.DataConverter;
import com.kmood.datahandle.FMConfiguration;
import com.kmood.utils.FileUtils;
import com.kmood.utils.StringUtil;
import com.kmood.utils.ZipUtils;
import com.kmood.word.WordModelHandlerImpl;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lingala.zip4j.ZipFile;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DocumentProducer {
    private ThreadLocal<String> ActualModelPathLocal = new ThreadLocal();
    private ThreadLocal<String> ActualModelNameLocal = new ThreadLocal();
    private ThreadLocal<String> ActualModelOriginPathLocal = new ThreadLocal();
    private ThreadLocal<String> ActualModelDocxPathLocal = new ThreadLocal();
    private ThreadLocal<String> ActualExtractDocxPathLocal = new ThreadLocal();
    public static ThreadLocal<String> ModelSuffixFlagLocal = new ThreadLocal();
    public static ThreadLocal<Integer> PicCountLocal = new ThreadLocal();

    public DocumentProducer(Configuration CustomerConfig, String ActualModelPath) {
        FMConfiguration.Init(CustomerConfig);
        this.ActualModelPathLocal.set(ActualModelPath);
    }

    public DocumentProducer(String ActualModelPath) throws Exception {
        FMConfiguration.Init();
        Configuration configuration = FMConfiguration.addFMModelPath(ActualModelPath);
        this.ActualModelPathLocal.set(ActualModelPath);
    }

    public DocumentProducer() throws Exception {
        FMConfiguration.Init();
    }

    public String Complie(String XmlModelPath, String XmlModelName, boolean debugModel) throws Exception {
        ModelSuffixFlagLocal.set("xml");
        if ("docx".equalsIgnoreCase(FileUtils.getFileSuffixByPath(XmlModelPath + File.separator + XmlModelName))) {
            String uid = UUID.randomUUID().toString();
            ModelSuffixFlagLocal.set("docx");
            this.ActualModelOriginPathLocal.set(XmlModelPath + File.separator + XmlModelName);
            String docxFilePath = XmlModelPath + File.separator + XmlModelName;
            String compressPath = XmlModelPath + File.separator + XmlModelName.substring(0, XmlModelName.lastIndexOf(".")) + "_" + uid;
            this.ActualExtractDocxPathLocal.set(compressPath);
            new ZipFile(docxFilePath).extractAll(compressPath);
            XmlModelPath = XmlModelPath + File.separator + XmlModelName.substring(0, XmlModelName.lastIndexOf(".")) + "_" + uid + File.separator + "word" + File.separator;
            XmlModelName = "document.xml";
            FMConfiguration.clearFMModelPathArr();
            this.ActualModelPathLocal.remove();
            this.ActualModelDocxPathLocal.set(XmlModelPath + File.separator + XmlModelName);
        }
        if (StringUtil.isBlank((CharSequence)this.ActualModelPathLocal.get())) {
            FMConfiguration.addFMModelPath(XmlModelPath);
            this.ActualModelPathLocal.set(XmlModelPath);
        }
        if (debugModel) {
            WordModelHandlerImpl wordXmlModelHandler = new WordModelHandlerImpl();
            String string = wordXmlModelHandler.WordXmlModelHandle(XmlModelPath + File.separator + XmlModelName, this.ActualModelPathLocal.get());
        }
        this.ActualModelNameLocal.set(XmlModelName + ".ftl");
        return XmlModelPath + File.separator + XmlModelName + ".ftl";
    }

    public void produce(Object data, String ProduceFilePath) throws Exception {
        String produceFilePathOrigin = ProduceFilePath;
        if ("docx".equalsIgnoreCase(ModelSuffixFlagLocal.get())) {
            ProduceFilePath = this.ActualModelDocxPathLocal.get();
        }
        Configuration configuration = FMConfiguration.getConfiguration();
        String modelFileName = this.ActualModelNameLocal.get();
        String modelPath = this.ActualModelPathLocal.get();
        Template template = configuration.getTemplate(modelFileName);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ProduceFilePath), template.getEncoding());
        if ("docx".equalsIgnoreCase(ModelSuffixFlagLocal.get())) {
            data = DataConverter.addPictureXh(data, "");
            File metaFolder = new File(modelPath + File.separator + "media");
            if (!metaFolder.exists()) {
                metaFolder.mkdir();
            }
            HashMap renderData = (HashMap)data;
            this.dealPicture(renderData, modelPath);
        }
        Object dataConvert = DataConverter.convert(data, null);
        template.process(dataConvert, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
        outputStreamWriter.close();
        if ("docx".equalsIgnoreCase(ModelSuffixFlagLocal.get())) {
            String sourceFolderPath = this.ActualExtractDocxPathLocal.get();
            new File(ProduceFilePath + ".ftl").delete();
            ZipUtils.compress(produceFilePathOrigin, sourceFolderPath);
            System.out.println(FileUtils.deleteDir(new File(sourceFolderPath)));
        }
    }

    public void produce(Object data, OutputStream ProduceFileout) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(ProduceFileout, template.getEncoding());
        Object dataConvert = DataConverter.convert(data, null);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    public void produce(Object data, OutputStream ProduceFileout, Config config) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(ProduceFileout, template.getEncoding());
        Object dataConvert = DataConverter.convert(data, config);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    public void produce(Object data, String ProduceFilePath, Config config) throws IOException, TemplateException {
        Configuration configuration = FMConfiguration.getConfiguration();
        Template template = configuration.getTemplate(this.ActualModelNameLocal.get());
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ProduceFilePath), template.getEncoding());
        Object dataConvert = DataConverter.convert(data, config);
        template.process(dataConvert, (Writer)outputStreamWriter);
    }

    private void dealPicture(Map renderData, String modelPath) throws Exception {
        for (Object key : renderData.keySet()) {
            String base64png;
            String bas64flag;
            Object obj = renderData.get(key);
            if (obj != null && obj.getClass().equals(ArrayList.class)) {
                ArrayList mapList = (ArrayList)obj;
                for (Object mapItem : mapList) {
                    this.dealPicture((Map)mapItem, modelPath);
                }
            }
            if (!"png".equalsIgnoreCase(bas64flag = FileUtils.checkImageBase64Format(base64png = renderData.get(key) != null ? renderData.get(key).toString() : ""))) continue;
            if (renderData.containsKey("_xh")) {
                FileUtils.convertBase64DataToImage(base64png, modelPath + File.separator + "media" + File.separator + "image" + renderData.get("_xh") + key + ".png");
            } else {
                FileUtils.convertBase64DataToImage(base64png, modelPath + File.separator + "media" + File.separator + "image" + key + ".png");
            }
            SAXReader reader = new SAXReader();
            File relsDocumentXmlFile = new File(modelPath + File.separator + "_rels" + File.separator + "document.xml.rels");
            Document document = reader.read(relsDocumentXmlFile);
            Element element = document.getRootElement();
            Element pictureRelationship = element.addElement("Relationship");
            pictureRelationship.addAttribute("Type", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            if (renderData.containsKey("_xh")) {
                pictureRelationship.addAttribute("Id", "rId" + renderData.get("_xh") + key);
                pictureRelationship.addAttribute("Target", "media/image" + renderData.get("_xh") + key + ".png");
            } else {
                pictureRelationship.addAttribute("Id", "rId" + key);
                pictureRelationship.addAttribute("Target", "media/image" + key + ".png");
            }
            FileOutputStream fos = new FileOutputStream(modelPath + File.separator + "_rels" + File.separator + "document.xml.rels");
            XMLWriter writer = new XMLWriter((OutputStream)fos);
            writer.write(document);
            writer.close();
            File contentTypesFolderFile = new File(modelPath).getParentFile();
            File contentTypesXmlFile = new File(contentTypesFolderFile.getAbsolutePath() + File.separator + "[Content_Types].xml");
            SAXReader readernew = new SAXReader();
            Document documentnew = readernew.read(contentTypesXmlFile);
            Element rootElementnew = documentnew.getRootElement();
            List elementsnew = rootElementnew.elements();
            List elementDeaultList = rootElementnew.elements("Default");
            boolean sfczpng = false;
            for (Element elementitem : elementDeaultList) {
                Attribute extension = elementitem.attribute("Extension");
                if (!"png".equalsIgnoreCase(extension.getData().toString())) continue;
                sfczpng = true;
            }
            if (sfczpng) continue;
            Element pictureRelationshipnew = DocumentHelper.createElement((QName)QName.get((String)"Default", (Namespace)rootElementnew.getNamespace()));
            pictureRelationshipnew.addAttribute("Extension", "png");
            pictureRelationshipnew.addAttribute("ContentType", "image/png");
            elementsnew.add(0, pictureRelationshipnew);
            FileOutputStream fosnew = new FileOutputStream(contentTypesFolderFile.getAbsolutePath() + File.separator + "[Content_Types].xml");
            XMLWriter writernew = new XMLWriter((OutputStream)fosnew);
            writernew.write(documentnew);
            writernew.close();
        }
    }
}

