/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.datahandle;

import com.kmood.utils.StringUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.util.ArrayList;

public class FMConfiguration {
    private static volatile Configuration configuration;
    private static Version FMVersion;
    private static TemplateExceptionHandler FMExceptionHandler;
    private static String FMEncoding;
    private static volatile ArrayList<String> FMModelPathArr;

    public static void Init(Configuration config) {
        if (config != null) {
            configuration = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void Init(Version FMVersion, String encoding, TemplateExceptionHandler ExceptionHandler) {
        if (configuration != null) return;
        Class<FMConfiguration> clazz = FMConfiguration.class;
        synchronized (FMConfiguration.class) {
            if (configuration != null) return;
            if (FMVersion != null) {
                configuration = new Configuration(FMVersion);
            }
            if (ExceptionHandler != null) {
                configuration.setTemplateExceptionHandler(ExceptionHandler);
            }
            if (encoding == null) return;
            configuration.setDefaultEncoding(encoding);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void Init() {
        if (configuration != null) return;
        Class<FMConfiguration> clazz = FMConfiguration.class;
        synchronized (FMConfiguration.class) {
            if (configuration != null) return;
            configuration = new Configuration(FMVersion);
            configuration.setTemplateExceptionHandler(FMExceptionHandler);
            configuration.setDefaultEncoding(FMEncoding);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Configuration addFMModelPath(String fmModelPath) throws Exception {
        TemplateLoader[] loaders;
        if (StringUtil.isBlank((CharSequence)fmModelPath)) {
            return configuration;
        }
        int length = fmModelPath.length();
        fmModelPath = fmModelPath.replace("\\", File.separator);
        if (FMModelPathArr.contains(fmModelPath = fmModelPath.replace("/", File.separator))) {
            return configuration;
        }
        TemplateLoader tl = configuration.getTemplateLoader();
        if (tl == null || tl instanceof MultiTemplateLoader) {
            FMModelPathArr.add(fmModelPath);
            loaders = new TemplateLoader[FMModelPathArr.size()];
            for (int i = 0; i < FMModelPathArr.size(); ++i) {
                loaders[i] = new FileTemplateLoader(new File(FMModelPathArr.get(i)));
            }
        } else {
            throw new RuntimeException("freemaker \u914d\u7f6e\u5bf9\u5e94\u7684\u6a21\u677f\u52a0\u8f7d\u5668\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u82e5\u4f7f\u7528\u81ea\u5b9a\u4e49\u914d\u7f6e\uff0c\u8bf7\u8c03\u6574\u6a21\u677f\u4f4d\u7f6e\uff01\u65e0\u9700\u8c03\u7528\u65b9\u6cd5\uff01");
        }
        MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
        configuration.setTemplateLoader((TemplateLoader)mtl);
        return configuration;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static void clearFMModelPathArr() {
        FMModelPathArr = new ArrayList();
    }

    static {
        FMVersion = Configuration.VERSION_2_3_28;
        FMExceptionHandler = TemplateExceptionHandler.RETHROW_HANDLER;
        FMEncoding = "UTF-8";
        FMModelPathArr = new ArrayList();
    }
}

