/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToStringByFilepath(String filePath) throws IOException {
        StringBuilder data = new StringBuilder();
        try (Reader reader = null;){
            File file = new File(filePath);
            reader = new FileReader(file);
            char[] c = new char[1024];
            int len = 0;
            while ((len = reader.read(c)) != -1) {
                data.append(String.copyValueOf(c, 0, len));
            }
        }
        return data.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readToBytesByFilepath(String filePath) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (FileInputStream reader = null;){
            File file = new File(filePath);
            reader = new FileInputStream(file);
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = reader.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        return output.toByteArray();
    }

    public static String getFileSuffixByPath(String path) {
        File file = new File(path);
        String fileName = file.getName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        return suffix;
    }

    public static String checkImageBase64Format(String base64ImgData) {
        try {
            byte[] b = Base64.getDecoder().decode(base64ImgData);
            String type = "";
            if (16973 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
                type = "bmp";
            } else if (35152 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
                type = "png";
            } else if (65496 == ((b[0] & 0xFF) << 8 | b[1] & 0xFF)) {
                type = "jpg";
            }
            return type;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void convertBase64DataToImage(String base64ImgData, String filePath) throws IOException {
        FileUtils.GenerateImage(base64ImgData, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetImageStr(String imgPath) {
        String imgFile = imgPath;
        FileInputStream in = null;
        byte[] data = null;
        String encode = null;
        BASE64Encoder encoder = new BASE64Encoder();
        try {
            in = new FileInputStream(imgFile);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            encode = encoder.encode(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean GenerateImage(String imgData, String imgFilePath) throws IOException {
        if (imgData == null) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        OutputStream out = null;
        try {
            out = new FileOutputStream(imgFilePath);
            byte[] b = decoder.decodeBuffer(imgData);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            out.write(b);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
            return true;
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean delDir(File file) {
        if (file.isDirectory()) {
            File[] zFiles;
            for (File file2 : zFiles = file.listFiles()) {
                FileUtils.delDir(file2);
            }
            file.delete();
        } else {
            file.delete();
        }
        return true;
    }
}

