/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.word;

import com.kmood.basic.ModelHandler;
import com.kmood.basic.PlaceHolder;
import com.kmood.basic.SyntaxException;
import com.kmood.datahandle.DocumentProducer;
import com.kmood.datahandle.FMConfiguration;
import com.kmood.utils.FileUtils;
import com.kmood.utils.StringUtil;
import com.kmood.word.WordParserUtils;
import freemarker.template.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class WordModelHandlerImpl
implements ModelHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String VerifyModel(String xmlPath, String ftlOutputPath) throws Exception {
        String errorInfo = null;
        try (Writer writer = null;){
            Configuration configuration = FMConfiguration.getConfiguration();
            SAXReader reader = new SAXReader();
            File xmlFile = new File(xmlPath);
            String name = xmlFile.getName();
            Document document = reader.read(xmlFile);
            Element rootElement = document.getRootElement();
            WordParserUtils.clearPictureContent(document);
            WordParserUtils.handleESC(document);
            List pictList = document.selectNodes(".//v:shape");
            for (int i = 0; pictList != null && i < pictList.size(); ++i) {
                Element node = (Element)pictList.get(i);
                Attribute alt = node.attribute("alt");
                if (alt == null || StringUtil.isBlank((CharSequence)alt.getText()) || (errorInfo = WordParserUtils.VarifySyntax(StringUtil.removeInvisibleChar(alt.getText()))) == null || errorInfo.length() == 0) continue;
                throw new SyntaxException("(\u56fe\u7247\u5360\u4f4d\u7b26)" + errorInfo);
            }
            List ParagList = document.selectNodes(".//w:p");
            StringBuilder wpStr = new StringBuilder();
            for (int i = 0; i < ParagList.size(); ++i) {
                Node node = (Node)ParagList.get(i);
                List TextNodeList = node.selectNodes(".//w:t");
                for (int j = 0; j < TextNodeList.size(); ++j) {
                    Node TextNode = (Node)TextNodeList.get(j);
                    String text = TextNode.getText();
                    wpStr.append(StringUtil.removeInvisibleChar(text));
                }
            }
            errorInfo = WordParserUtils.VarifySyntax(wpStr.toString());
            if (errorInfo != null && errorInfo.length() != 0) {
                throw new SyntaxException(errorInfo);
            }
            ftlOutputPath = ftlOutputPath == null ? xmlPath + ".ftl" : ftlOutputPath + File.separator + name + ".ftl";
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(ftlOutputPath), configuration.getDefaultEncoding());
            document.write(writer);
            writer.flush();
        }
        return ftlOutputPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ConverToFreemaker(String ftlOutputPath) throws DocumentException, IOException {
        try (Writer writer = null;){
            Configuration configuration = FMConfiguration.getConfiguration();
            SAXReader reader = new SAXReader();
            File file = new File(ftlOutputPath);
            Document document = reader.read(file);
            List list = document.selectNodes("//w:p");
            for (int i = 0; i < list.size(); ++i) {
                Node WPNode = (Node)list.get(i);
                WordParserUtils.PlaceHodlerHandle(WPNode);
                WordParserUtils.SpecialPlaceHodlerHandle(WPNode);
                WordParserUtils.MediaPlaceHodlerHandle(WPNode);
            }
            WordParserUtils.BracketToListConversion(document);
            List pictureList = document.selectNodes("//w:pict");
            if (pictureList != null) {
                for (int i = 0; i < pictureList.size(); ++i) {
                    String alt;
                    Element node = (Element)pictureList.get(i);
                    Element shapeNode = (Element)node.selectSingleNode("./v:shape");
                    Element binDataNode = (Element)node.selectSingleNode("./w:binData");
                    if (binDataNode == null && shapeNode != null) {
                        alt = shapeNode.attributeValue("alt");
                        if (!StringUtil.isNotBlank((CharSequence)alt)) continue;
                        shapeNode.addAttribute("alt", alt.replaceAll("\\{\\^[\\s\\S]*\\^}", ""));
                        continue;
                    }
                    if (binDataNode == null || shapeNode == null || (alt = shapeNode.attributeValue("alt")) == null || !alt.contains("{^")) continue;
                    if (StringUtil.isNotBlank((CharSequence)alt)) {
                        shapeNode.addAttribute("alt", alt.replaceAll("\\{\\^[\\s\\S]*\\^}", ""));
                    }
                    String s = StringUtil.substringBetween(alt, "{^", "^}");
                    binDataNode.setText("{" + s + "}");
                }
            }
            if ("docx".equalsIgnoreCase(DocumentProducer.ModelSuffixFlagLocal.get())) {
                List docxPictureList = document.selectNodes("//w:drawing");
                for (Element picEle : docxPictureList) {
                    Attribute aExtNodeUriAttr;
                    picEle.addNamespace("pic", "http://schemas.openxmlformats.org/drawingml/2006/picture");
                    picEle.addNamespace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
                    Element picNode = (Element)picEle.selectSingleNode(".//pic:cNvPr");
                    String pic_descr = picNode.attributeValue("descr");
                    Element aExtNode = (Element)picEle.selectSingleNode(".//a:ext");
                    if (aExtNode != null && (aExtNodeUriAttr = aExtNode.attribute("uri")) != null) {
                        aExtNodeUriAttr.setValue("");
                    }
                    if (pic_descr == null || pic_descr.equalsIgnoreCase("")) continue;
                    String picTemp = StringUtil.substringBetween(pic_descr, "{^", "^}");
                    Attribute descrAttr = picNode.attribute("descr");
                    descrAttr.setValue("");
                    Element wpDocprNode = (Element)picEle.selectSingleNode(".//wp:docPr");
                    Attribute wpDocprNodeAttr = wpDocprNode.attribute("descr");
                    wpDocprNodeAttr.setValue("");
                    if (!picTemp.contains(".")) {
                        picTemp = "rId" + picTemp;
                    } else {
                        String[] split = picTemp.split("\\.");
                        picTemp = "rId{" + split[0] + "._xh}" + split[1];
                    }
                    Element aBlipNode = (Element)picEle.selectSingleNode(".//a:blip");
                    Attribute aBlipNodeEmbedAttr = aBlipNode.attribute("embed");
                    aBlipNodeEmbedAttr.setValue(picTemp);
                }
            }
            String name = file.getName();
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(ftlOutputPath), configuration.getDefaultEncoding());
            document.write(writer);
            writer.flush();
            String string = ftlOutputPath;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void XmlPlaceHolderHandler(String xmlFtlPath) throws IOException {
        try (FileOutputStream out = null;){
            Configuration configuration = FMConfiguration.getConfiguration();
            String xmModelStr = new String(FileUtils.readToBytesByFilepath(xmlFtlPath), configuration.getDefaultEncoding());
            String body = StringUtil.substringBetween(xmModelStr, "<w:body>", "</w:body>");
            body = WordParserUtils.IfTagHandle(body);
            body = WordParserUtils.ListTagHandle(body);
            body = WordParserUtils.BraceTagHandle(body);
            body = PlaceHolder.FromESC(body);
            out = new FileOutputStream(xmlFtlPath);
            xmModelStr = xmModelStr.substring(0, xmModelStr.indexOf("<w:body>")) + "<w:body>" + body + "</w:body>" + xmModelStr.substring(xmModelStr.lastIndexOf("</w:body>") + 9);
            out.write(xmModelStr.getBytes(configuration.getDefaultEncoding()));
            out.flush();
        }
    }

    public String WordXmlModelHandle(String xmlPath, String ActualModelPath) throws Exception {
        String actualModelPath = this.VerifyModel(xmlPath, ActualModelPath);
        this.ConverToFreemaker(actualModelPath);
        this.XmlPlaceHolderHandler(actualModelPath);
        return actualModelPath;
    }
}

