/*
 * Decompiled with CFR 0.152.
 */
package com.kmood.word;

import com.kmood.basic.PlaceHolder;
import com.kmood.basic.SyntaxException;
import com.kmood.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class WordParserUtils {
    public static void clearPictureContent(Document document) {
        List pictureList = document.selectNodes(".//w:binData");
        if (pictureList != null) {
            for (int i = 0; i < pictureList.size(); ++i) {
                String text;
                Attribute alt;
                Node node = (Node)pictureList.get(i);
                Element parent = node.getParent();
                Element vnode = (Element)parent.selectSingleNode("./v:shape");
                if (vnode == null || (alt = vnode.attribute("alt")) == null || !(text = alt.getText()).contains("{^")) continue;
                node.setText("   ");
            }
        }
    }

    public static String VarifySyntax(String data) {
        data = StringUtil.removeInvisibleChar(data);
        String errorInfor = "";
        Character errorChar = null;
        int errorIndex = 0;
        int length = data.length();
        if (length == 0) {
            return null;
        }
        char[] chars = data.toCharArray();
        ArrayList<Character> stack = new ArrayList<Character>();
        ArrayList<Character> charArr = new ArrayList<Character>();
        ArrayList<Integer> indexArr = new ArrayList<Integer>();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ("[]{}*#$@^".indexOf(c) == -1) continue;
            charArr.add(Character.valueOf(c));
            indexArr.add(i);
        }
        int dl = charArr.size();
        for (int i = 0; i < dl; ++i) {
            Character c = (Character)charArr.get(i);
            if (i == 0 && (c == PlaceHolder.AC || c == PlaceHolder.BRACE_RC || c == PlaceHolder.BRACKET_RC || c == PlaceHolder.XC || c == PlaceHolder.POUNDC || c == PlaceHolder.DC || c == PlaceHolder.PC)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            int s = stack.size();
            if (s == 0) {
                stack.add(c);
                continue;
            }
            if (c.charValue() == '}' && !PlaceHolder.BELIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == ']' && !PlaceHolder.BLIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '{' && !PlaceHolder.BERIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '[' && !PlaceHolder.BRIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '@' && !PlaceHolder.AIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '*' && !PlaceHolder.XJIsEffective(charArr, stack, i, '*')) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '#' && !PlaceHolder.XJIsEffective(charArr, stack, i, '#')) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '$' && !PlaceHolder.DIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '^' && !PlaceHolder.PIsEffective(charArr, stack, i)) {
                errorChar = c;
                errorIndex = i;
                break;
            }
            if (c.charValue() == '[' || c.charValue() == '{' || c.charValue() == '*' && stack.get(s - 1).charValue() != '*' || c.charValue() == '#' && stack.get(s - 1).charValue() != '#' || c.charValue() == '$' && stack.get(s - 1).charValue() != '$' || c.charValue() == '^' && stack.get(s - 1).charValue() != '^') {
                stack.add(c);
            }
            if (!(c.charValue() == ']' || c.charValue() == '}' || c.charValue() == '*' && stack.get(s - 1).charValue() == '*' || c.charValue() == '#' && stack.get(s - 1).charValue() == '#' || c.charValue() == '$' && stack.get(s - 1).charValue() == '$') && (c.charValue() != '^' || stack.get(s - 1).charValue() != '^')) continue;
            stack.remove(s - 1);
        }
        if (errorChar != null) {
            errorInfor = errorInfor + StringUtil.substringBeforeAfterSize(data, (Integer)indexArr.get(errorIndex), 10) + "------'" + errorChar + "' \u5b58\u5728\u8bed\u6cd5\u9519\u8bef,\u6ce8\u610f\u5c06\u7279\u6b8a\u5b57\u7b26\u8fdb\u884c\u8f6c\u4e49";
        }
        return errorInfor;
    }

    public static Element AddParentNode_JH(Element beginEle, Element endEle, String name, HashMap<String, String> attMap) {
        int j;
        int j2;
        Element endEleParent;
        if (beginEle == null || endEle == null) {
            return null;
        }
        Element beginEleParent = beginEle.getParent();
        if (!beginEleParent.equals(endEleParent = endEle.getParent())) {
            throw new RuntimeException("\u6a21\u677f\u5360\u4f4d\u7b26\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a-----" + beginEle.getText() + "-----\u90e8\u5206\u7684\u5360\u4f4d\u7b26\u8d77\u59cb\u7b26\u4e0e\u7ed3\u675f\u7b26\u4e0d\u540c\u7ea7");
        }
        List elements = beginEleParent.elements();
        ArrayList<Element> elementPrefixArr = new ArrayList<Element>();
        ArrayList<Element> elementArr = new ArrayList<Element>();
        ArrayList<Element> elementSubfixArr = new ArrayList<Element>();
        int beginIndex = elements.indexOf(beginEle);
        int endIndex = elements.indexOf(endEle);
        for (j2 = 0; j2 < elements.size(); ++j2) {
            Element e = (Element)elements.get(j2);
            if (j2 < beginIndex) {
                elementPrefixArr.add(e);
            } else if (j2 > endIndex) {
                elementSubfixArr.add(e);
            } else {
                elementArr.add(e);
            }
            beginEleParent.remove(e);
        }
        for (j2 = 0; j2 < elementPrefixArr.size(); ++j2) {
            beginEleParent.add((Element)elementPrefixArr.get(j2));
        }
        Element element = beginEleParent.addElement(name);
        Set<String> keyset = attMap.keySet();
        for (String key : keyset) {
            element.addAttribute(key, attMap.get(key));
        }
        for (j = 0; j < elementArr.size(); ++j) {
            element.add((Element)elementArr.get(j));
        }
        for (j = 0; j < elementSubfixArr.size(); ++j) {
            beginEleParent.add((Element)elementSubfixArr.get(j));
        }
        return element;
    }

    public static Element AddParentNode_XH(Element beginEle, Element endEle, String name, HashMap<String, String> attMap) {
        int j;
        int j2;
        if (beginEle == null || endEle == null) {
            return null;
        }
        Element beginEleParent = beginEle.getParent();
        List elements = beginEleParent.elements();
        ArrayList<Element> elementPrefixArr = new ArrayList<Element>();
        ArrayList<Element> elementArr = new ArrayList<Element>();
        ArrayList<Element> elementSubfixArr = new ArrayList<Element>();
        int beginIndex = elements.indexOf(beginEle);
        int endIndex = elements.indexOf(endEle);
        for (j2 = 0; j2 < elements.size(); ++j2) {
            Element e = (Element)elements.get(j2);
            if (j2 < beginIndex) {
                elementPrefixArr.add(e);
            } else if (j2 > endIndex) {
                elementSubfixArr.add(e);
            } else {
                elementArr.add(e);
            }
            beginEleParent.remove(e);
        }
        for (j2 = 0; j2 < elementPrefixArr.size(); ++j2) {
            beginEleParent.add((Element)elementPrefixArr.get(j2));
        }
        Element element = beginEleParent.addElement(name);
        Set<String> keyset = attMap.keySet();
        for (String key : keyset) {
            element.addAttribute(key, attMap.get(key));
        }
        for (j = 0; j < elementArr.size(); ++j) {
            element.add((Element)elementArr.get(j));
        }
        for (j = 0; j < elementSubfixArr.size(); ++j) {
            beginEleParent.add((Element)elementSubfixArr.get(j));
        }
        return element;
    }

    public static Element AddParentNode(Element ele, String parentName, HashMap<String, String> Attr) {
        int i;
        if (ele == null) {
            return null;
        }
        Element parent = ele.getParent();
        List elements = parent.elements();
        int eleIndex = elements.indexOf(ele);
        ArrayList<Element> elementsPrefix = new ArrayList<Element>();
        ArrayList<Element> elementsSubfix = new ArrayList<Element>();
        for (i = 0; i < elements.size(); ++i) {
            Element e = (Element)elements.get(i);
            if (i < eleIndex) {
                elementsPrefix.add(e);
            }
            if (eleIndex < i) {
                elementsSubfix.add(e);
            }
            parent.remove(e);
        }
        for (i = 0; i < elementsPrefix.size(); ++i) {
            Element element = (Element)elementsPrefix.get(i);
            parent.add(element);
        }
        Element parentNameEle = parent.addElement(parentName);
        Set<String> keyset = Attr.keySet();
        for (String key : keyset) {
            parentNameEle.addAttribute(key, Attr.get(key));
        }
        parentNameEle.add(ele);
        for (int i2 = 0; i2 < elementsSubfix.size(); ++i2) {
            Element element = (Element)elementsSubfix.get(i2);
            parent.add(element);
        }
        return parentNameEle;
    }

    public static String ListTagHandle(String xmlStrTemp) {
        String xmlStrNew = "";
        if (xmlStrTemp == null) {
            return null;
        }
        if (xmlStrTemp.length() == 0) {
            return "";
        }
        while (xmlStrTemp.contains("<#list")) {
            xmlStrNew = xmlStrNew + StringUtil.substringBefore(xmlStrTemp, "<#list");
            xmlStrNew = xmlStrNew + "<#list ";
            String xmlStrSubfix = StringUtil.substringAfter(xmlStrTemp, "<#list");
            String tagContent = StringUtil.substringBefore(xmlStrSubfix, ">");
            String cont = StringUtil.substringBetween(tagContent, "content=\"", "\"");
            xmlStrNew = xmlStrNew + cont.replaceAll("@", " as ") + " >";
            xmlStrTemp = StringUtil.substringAfter(xmlStrSubfix, ">");
        }
        xmlStrNew = xmlStrNew + xmlStrTemp;
        return xmlStrNew;
    }

    public static String IfTagHandle(String xmlStr) {
        String xmlStrTemp = "";
        if (xmlStr == null) {
            return null;
        }
        if (xmlStr.length() == 0) {
            return "";
        }
        while (xmlStr.contains("<#if")) {
            xmlStrTemp = xmlStrTemp + StringUtil.substringBefore(xmlStr, "<#if");
            xmlStrTemp = xmlStrTemp + "<#if ";
            String xmlStrSubfix = StringUtil.substringAfter(xmlStr, "<#if");
            String tagContent = StringUtil.substringBefore(xmlStrSubfix, ">");
            String cont = StringUtil.substringBetween(tagContent, "content=\"", "\"");
            xmlStrTemp = xmlStrTemp + StringUtils.substringBefore((String)cont, (String)"@") + ")?? >";
            xmlStr = StringUtil.substringAfter(xmlStrSubfix, ">");
        }
        xmlStrTemp = xmlStrTemp + xmlStr;
        return xmlStrTemp;
    }

    public static String BraceTagHandle(String xmlStr) {
        if (xmlStr == null) {
            return null;
        }
        if (xmlStr.length() == 0) {
            return "";
        }
        String[] arr = StringUtil.substringsBetween(xmlStr, "{", "}");
        if (arr == null) {
            return xmlStr;
        }
        for (String str : arr) {
            String replaceStr = "{" + str + "}";
            str = str.replaceAll("[\\x00-\\x1F | \\x7F ]", "");
            String s = "${(" + str + ")!\"\"}";
            if (!str.contains(".")) {
                xmlStr = xmlStr.replace(replaceStr, s);
                continue;
            }
            String cond = "";
            int length = str.length();
            int one = str.indexOf(46);
            while (one < length - 1 && one != -1) {
                cond = cond + " (";
                cond = cond + str.substring(0, one);
                cond = cond + ")?? &&";
                one = str.indexOf(46, one + 1);
            }
            cond = cond.substring(0, cond.length() - 3);
            xmlStr = xmlStr.replace(replaceStr, "<#if " + cond + " >" + s + "</#if>");
        }
        return xmlStr;
    }

    public static void BracketToListConversion(Document document) {
        List wpNodeList = document.selectNodes("//w:p");
        for (int i = 0; i < wpNodeList.size(); ++i) {
            Node wpNode = (Node)wpNodeList.get(i);
            List wtlist = wpNode.selectNodes(".//w:t");
            String[] Xarr = null;
            String[] Jarr = null;
            for (int j = 0; j < wtlist.size(); ++j) {
                Node node = (Node)wtlist.get(j);
                String text1 = node.getText();
                if (text1 != null && text1.contains("[#")) {
                    for (String s : Jarr = StringUtil.substringsBetween(text1, "[#", "#")) {
                        node.setText(text1.replace("[#" + s + "#", ""));
                    }
                }
                if (text1 == null || !text1.contains("[*")) continue;
                for (String s : Xarr = StringUtil.substringsBetween(text1, "[*", "*")) {
                    node.setText(text1.replace("[*" + s + "*", ""));
                }
            }
            if (Jarr != null) {
                String s = "#";
                for (int g = 0; g < Jarr.length; ++g) {
                    WordParserUtils.converList_JH(wpNodeList, i, (Element)wpNode, (String)Jarr[g], s);
                }
            }
            if (Xarr == null) continue;
            String s = "*";
            for (int g = 0; g < Xarr.length; ++g) {
                WordParserUtils.converList_XH(wpNodeList, i, (Element)wpNode, (String)Xarr[g], s);
            }
        }
    }

    private static void converList_JH(List wpNodeList, int i, Element wpNode, String value, String s) {
        Element beginEle;
        if ("#".equals(s)) {
            for (beginEle = wpNode; beginEle != null && !"tr".equals(beginEle.getName()); beginEle = beginEle.getParent()) {
            }
        }
        if ("*".equals(s)) {
            while (beginEle != null && !"p".equals(beginEle.getName())) {
                beginEle = beginEle.getParent();
            }
        }
        Element endEle = null;
        String valueTrim = StringUtil.substringBefore(StringUtil.removeInvisibleChar(value), "@").trim();
        String t = s + valueTrim + s + "]";
        for (int j = i; j < wpNodeList.size(); ++j) {
            Node temp = (Node)wpNodeList.get(j);
            List wtlisttemp = temp.selectNodes(".//w:t");
            for (int k = 0; k < wtlisttemp.size(); ++k) {
                String[] vArr;
                Node node = (Node)wtlisttemp.get(k);
                String text1 = node.getText();
                if (text1 == null || !StringUtil.removeInvisibleChar(text1).contains(t) || !StringUtil.removeInvisibleChar(text1).contains(t)) continue;
                for (String str : vArr = StringUtil.substringsBetween(text1, s, "]")) {
                    String s1 = valueTrim + s;
                    if (!s1.equals(StringUtil.removeInvisibleChar(str))) continue;
                    node.setText(text1.replace(s + str + "]", ""));
                }
                endEle = (Element)temp;
            }
        }
        if (endEle == null) {
            throw new SyntaxException(beginEle.getText() + "-----'" + value + "'\u672a\u5339\u914d\u5230\u7ed3\u675f\u7b26");
        }
        if ("#".equals(s)) {
            while (endEle != null && !"tr".equals(endEle.getName())) {
                endEle = endEle.getParent();
            }
        }
        if ("*".equals(s)) {
            while (endEle != null && !"p".equals(endEle.getName())) {
                endEle = endEle.getParent();
            }
        }
        HashMap<String, String> listAttMap = new HashMap<String, String>();
        listAttMap.put("type", "list");
        listAttMap.put("content", " " + value + " ");
        HashMap<String, String> ifAttMap = new HashMap<String, String>();
        ifAttMap.put("type", "if");
        ifAttMap.put("content", " (" + StringUtil.substringBefore(value, " ").trim() + ")??");
        String name = "#list";
        Element element = WordParserUtils.AddParentNode_JH(beginEle, endEle, name, listAttMap);
        WordParserUtils.AddParentNode(element, "#if", ifAttMap);
    }

    private static void converList_XH(List wpNodeList, int i, Element BwpNode, String value, String s) {
        Element beginEle;
        if ("*".equals(s)) {
            for (beginEle = BwpNode; beginEle != null && !"p".equals(beginEle.getName()); beginEle = beginEle.getParent()) {
            }
        }
        Element eLEEle_wp = null;
        Object eLEEle = null;
        String valueTrim = StringUtil.substringBefore(StringUtil.removeInvisibleChar(value), "@").trim();
        String t = s + valueTrim + s + "]";
        for (int j = i; j < wpNodeList.size(); ++j) {
            Node temp = (Node)wpNodeList.get(j);
            List wtlisttemp = temp.selectNodes(".//w:t");
            for (int k = 0; k < wtlisttemp.size(); ++k) {
                String[] vArr;
                Node node = (Node)wtlisttemp.get(k);
                String text1 = node.getText();
                if (text1 == null || !StringUtil.removeInvisibleChar(text1).contains(t) || !StringUtil.removeInvisibleChar(text1).contains(t)) continue;
                for (String str : vArr = StringUtil.substringsBetween(text1, s, "]")) {
                    String s1 = valueTrim + s;
                    if (!s1.equals(StringUtil.removeInvisibleChar(str))) continue;
                    node.setText(text1.replace(s + str + "]", ""));
                }
                eLEEle_wp = (Element)temp;
            }
        }
        if (eLEEle_wp == null) {
            throw new SyntaxException(beginEle.getText() + "-----'" + value + "'\u672a\u5339\u914d\u5230\u7ed3\u675f\u7b26");
        }
        if ("*".equals(s)) {
            while (eLEEle_wp != null && !eLEEle_wp.getParent().equals(beginEle.getParent())) {
                eLEEle_wp = eLEEle_wp.getParent();
            }
        }
        Element parent = beginEle.getParent();
        Element parent1 = eLEEle_wp.getParent();
        boolean equals = parent1.equals(parent);
        HashMap<String, String> listAttMap = new HashMap<String, String>();
        listAttMap.put("type", "list");
        listAttMap.put("content", " " + value + " ");
        HashMap<String, String> ifAttMap = new HashMap<String, String>();
        ifAttMap.put("type", "if");
        ifAttMap.put("content", " (" + StringUtil.substringBefore(value, " ").trim() + ")??");
        String name = "#list";
        Element element = WordParserUtils.AddParentNode_XH(beginEle, eLEEle_wp, name, listAttMap);
        WordParserUtils.AddParentNode(element, "#if", ifAttMap);
    }

    public static void handleESC(Document document) {
        List wtNodeList = document.selectNodes(".//w:t");
        int s = wtNodeList.size();
        for (int i = 0; i < s; ++i) {
            Node o = (Node)wtNodeList.get(i);
            String text = o.getText();
            text = PlaceHolder.ToESC(text);
            o.setText(text);
            if (s - 1 == i || !text.endsWith("\\")) continue;
            Node o_s = (Node)wtNodeList.get(i + 1);
            String o_sText = o_s.getText();
            int l = o_sText.length();
            if (l == 1) {
                o_s.setText("");
                o.setText(PlaceHolder.ToESC(text + o_sText));
                continue;
            }
            if (l <= 1) continue;
            o_s.setText(o_sText.substring(1, o_sText.length()));
            o.setText(PlaceHolder.ToESC(text + o_sText.substring(0, 1)));
        }
    }

    public static void PlaceHodlerHandle(Node WPNode) {
        int fi;
        String text;
        int j;
        List WTList = WPNode.selectNodes(".//w:t");
        Node WTNodeNew = null;
        int s = WTList.size();
        block0: for (j = 0; j < s; ++j) {
            WTNodeNew = (Node)WTList.get(j);
            text = WTNodeNew.getText();
            fi = text.lastIndexOf(91);
            int xi = text.lastIndexOf("*");
            int ji = text.lastIndexOf("#");
            if (fi <= xi && fi <= ji) continue;
            WTNodeNew.setText(StringUtil.removeInvisibleChar(text.substring(0, fi)));
            String temp = text.substring(fi, text.length());
            for (int i = j; i <= s; ++i) {
                Node WTNodeNew_ = (Node)WTList.get(i);
                String t = WTNodeNew_.getText();
                WTNodeNew_.setText(StringUtil.removeInvisibleChar(t));
                temp = temp + t;
                int i1 = StringUtil.countMatches((CharSequence)temp, (char)'*');
                int i2 = StringUtil.countMatches((CharSequence)temp, (char)'#');
                int i3 = StringUtil.countMatches((CharSequence)temp, (char)'[');
                int i4 = StringUtil.countMatches((CharSequence)temp, (char)']');
                if (i1 > 1 || i2 > 1) {
                    int endIndex;
                    if (temp.contains("#")) {
                        endIndex = temp.indexOf(35, temp.indexOf(35) + 1) + 1;
                        t = temp.substring(endIndex, temp.length());
                        temp = StringUtil.removeInvisibleChar(temp.substring(0, endIndex));
                    }
                    if (temp.contains("*")) {
                        endIndex = temp.indexOf(42, temp.indexOf(42) + 1) + 1;
                        t = temp.substring(endIndex, temp.length());
                        temp = StringUtil.removeInvisibleChar(temp.substring(0, endIndex));
                    }
                    if (i == j) {
                        WTNodeNew.setText(WTNodeNew.getText() + temp + StringUtil.removeInvisibleChar(t));
                    } else {
                        WTNodeNew_.setText(StringUtil.removeInvisibleChar(t));
                        WTNodeNew.setText(WTNodeNew.getText() + temp);
                    }
                    j = i;
                    continue block0;
                }
                WTNodeNew_.setText("");
            }
        }
        block2: for (j = 0; j < s; ++j) {
            int di_;
            WTNodeNew = (Node)WTList.get(j);
            text = WTNodeNew.getText();
            int di = text.lastIndexOf(123);
            if (di <= (di_ = text.lastIndexOf(125))) continue;
            String temp = text.substring(di, text.length());
            for (int i = j + 1; i <= s; ++i) {
                Node WTNodeNew_ = (Node)WTList.get(i);
                String t = WTNodeNew_.getText();
                if (StringUtil.countMatches((CharSequence)(temp = temp + t), (char)'}') > 0) {
                    WTNodeNew.setText(text.substring(0, di));
                    WTNodeNew_.setText(StringUtil.removeInvisibleChar(temp));
                    j = i;
                    continue block2;
                }
                WTNodeNew_.setText("");
            }
        }
        block4: for (j = s - 1; j >= 0; --j) {
            WTNodeNew = (Node)WTList.get(j);
            text = WTNodeNew.getText();
            fi = text.indexOf(93);
            if (fi == -1) continue;
            String text_ = text.substring(0, fi + 1);
            int i1 = StringUtil.countMatches((CharSequence)text_, (char)'*');
            int i2 = StringUtil.countMatches((CharSequence)text_, (char)'#');
            if (!text_.contains("]") || !(i1 < 2 && i1 > 0 || i2 < 2 && i2 > 0) && (i1 != 0 || i2 != 0)) continue;
            WTNodeNew.setText(StringUtil.removeInvisibleChar(text.substring(fi + 1, text.length())));
            String temp = text.substring(0, fi + 1);
            for (int i = j; i >= 0; --i) {
                Node WTNodeNew_ = (Node)WTList.get(i);
                String t = WTNodeNew_.getText();
                temp = t + temp;
                if (StringUtil.countMatches((CharSequence)temp, (char)'*') > 1 || StringUtil.countMatches((CharSequence)temp, (char)'#') > 1) {
                    WTNodeNew_.setText(StringUtil.removeInvisibleChar(temp));
                    j = i;
                    continue block4;
                }
                WTNodeNew_.setText("");
            }
        }
    }

    public static void SpecialPlaceHodlerHandle(Node WPNode) {
        List WTList = WPNode.selectNodes(".//w:t");
        Node WTNodeNew = null;
        int s = WTList.size();
        for (int j = 0; j < s; ++j) {
            WTNodeNew = (Node)WTList.get(j);
            String text = WTNodeNew.getText();
            boolean containsFY = text.contains("~");
            if (!containsFY) continue;
            WTNodeNew.setText(StringUtils.replaceAll((String)text, (String)"~", (String)""));
            Element wrelement = WTNodeNew.getParent().addElement("w:r");
            Element brelement = wrelement.addElement("w:br");
            brelement.addAttribute("w:type", "page");
        }
    }

    public static void MediaPlaceHodlerHandle(Node WPNode) throws DocumentException {
        List WTList = WPNode.selectNodes(".//w:t");
        Node WTNodeNew = null;
        int s = WTList.size();
        for (int j = 0; j < s; ++j) {
            WTNodeNew = (Node)WTList.get(j);
            String text = WTNodeNew.getText();
            boolean containsFY = text.contains("{^");
            if (!containsFY) continue;
            String picTemp = StringUtil.substringBetween(text, "{^", "^}");
            WTNodeNew.setText(text.replace("{^" + picTemp + "^}", ""));
            Element wrelement = WTNodeNew.getParent();
            long picSizeX = new Double(4802400.0).longValue();
            long picSizeY = new Double(2962800.0).longValue();
            if (picTemp.contains("(")) {
                String sizeXy = StringUtil.substringBetween(picTemp, "(", ")");
                String[] split = sizeXy.split(",");
                picSizeX = new Double(360000.0 * Double.valueOf(split[0])).longValue();
                picSizeY = new Double(360000.0 * Double.valueOf(split[1])).longValue();
                picTemp = picTemp.replace("(" + sizeXy + ")", "");
            }
            if (!picTemp.contains(".")) {
                picTemp = "rId" + picTemp;
            } else {
                String[] split = picTemp.split("\\.");
                picTemp = "rId{" + split[0] + "._xh}" + split[1];
            }
            int docprid = new Random().nextInt(10000);
            Document document = DocumentHelper.parseText((String)("<w:r xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"  xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\"  xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" w:rsidR=\"000342F3\"><w:rPr><w:noProof/></w:rPr><w:drawing><wp:inline distT=\"0\"           distB=\"0\"           distL=\"0\"           distR=\"0\"           wp14:anchorId=\"060DCBCD\"           wp14:editId=\"5A501A9D\"><wp:extent cx=\"" + picSizeX + "\"           cy=\"" + picSizeY + "\"/><wp:docPr id=\"" + docprid + "\"          name=\"\u56fe\u7247 1\"/><wp:cNvGraphicFramePr><a:graphicFrameLocks xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"                     noChangeAspect=\"1\"/></wp:cNvGraphicFramePr><a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"><a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"><pic:pic xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\"><pic:nvPicPr><pic:cNvPr id=\"" + docprid + "\"           name=\"\"/><pic:cNvPicPr/></pic:nvPicPr><pic:blipFill><a:blip r:embed=\"" + picTemp + "\"/><a:stretch><a:fillRect/></a:stretch></pic:blipFill><pic:spPr><a:xfrm><a:off x=\"0\"       y=\"0\"/><a:ext cx=\"" + picSizeX + "\"       cy=\"" + picSizeY + "\"/></a:xfrm><a:prstGeom prst=\"rect\"><a:avLst/></a:prstGeom></pic:spPr></pic:pic></a:graphicData></a:graphic></wp:inline></w:drawing></w:r>"));
            Element rootElement = document.getRootElement();
            wrelement.add(rootElement);
        }
    }
}

