/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.api;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.api.IOpenAPI;
import com.github.kwai.open.request.AccessTokenRequest;
import com.github.kwai.open.request.RefreshTokenRequest;
import com.github.kwai.open.response.AccessTokenResponse;
import com.github.kwai.open.response.RefreshTokenResponse;
import com.github.kwai.open.utils.HttpUtils;
import com.github.kwai.open.utils.ValidatorUtils;

public class KwaiOpenOauthApi
implements IOpenAPI {
    private String appId = "";

    private KwaiOpenOauthApi(String appId) {
        this.appId = appId;
    }

    public static KwaiOpenOauthApi init(String appId) {
        return new KwaiOpenOauthApi(appId);
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public AccessTokenResponse getAccessToken(AccessTokenRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/oauth2/access_token", request.toQueryParam(this), AccessTokenResponse.class);
    }

    public RefreshTokenResponse refreshToken(RefreshTokenRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/oauth2/refresh_token", request.toQueryParam(this), RefreshTokenResponse.class);
    }
}

