/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.request;

import com.github.kwai.open.anotation.NotNull;
import com.github.kwai.open.api.IOpenAPI;
import com.github.kwai.open.request.BaseOpenApiRequest;
import com.github.kwai.open.request.CreateVideoRequest;
import com.github.kwai.open.response.StartUploadResponse;
import com.github.kwai.open.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;

public class VideoPublishRequest
extends BaseOpenApiRequest {
    @NotNull
    private String uploadToken;
    @NotNull
    private String caption;
    private String stereoType;
    @NotNull
    private byte[] cover;
    private Long merchantProductId;

    public VideoPublishRequest() {
    }

    public VideoPublishRequest(String accessToken) {
        super(accessToken);
    }

    public VideoPublishRequest(CreateVideoRequest createVideoRequest, StartUploadResponse startUploadResponse) {
        super(createVideoRequest.getAccessToken());
        this.uploadToken = startUploadResponse.getUploadToken();
        this.caption = createVideoRequest.getCaption();
        this.stereoType = createVideoRequest.getStereoType();
        this.cover = createVideoRequest.getCover();
        this.merchantProductId = createVideoRequest.getMerchantProductId();
    }

    public VideoPublishRequest(String accessToken, String uploadToken, String caption, String stereoType, byte[] cover) {
        super(accessToken);
        this.uploadToken = uploadToken;
        this.caption = caption;
        this.stereoType = stereoType;
        this.cover = cover;
    }

    public VideoPublishRequest(String accessToken, String uploadToken, String caption, String stereoType, byte[] cover, Long merchantProductId) {
        super(accessToken);
        this.uploadToken = uploadToken;
        this.caption = caption;
        this.stereoType = stereoType;
        this.cover = cover;
        this.merchantProductId = merchantProductId;
    }

    public String getUploadToken() {
        return this.uploadToken;
    }

    public void setUploadToken(String uploadToken) {
        this.uploadToken = uploadToken;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getStereoType() {
        return this.stereoType;
    }

    public void setStereoType(String stereoType) {
        this.stereoType = stereoType;
    }

    public byte[] getCover() {
        return this.cover;
    }

    public void setCover(byte[] cover) {
        this.cover = cover;
    }

    public Long getMerchantProductId() {
        return this.merchantProductId;
    }

    public void setMerchantProductId(Long merchantProductId) {
        this.merchantProductId = merchantProductId;
    }

    @Override
    public Map<String, Object> toQueryParam(IOpenAPI openAPI) {
        Map<String, Object> map = super.toQueryParam(openAPI);
        map.put("upload_token", this.uploadToken);
        return map;
    }

    public Map<String, Object> toDataParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caption", this.caption);
        if (this.stereoType != null) {
            map.put("stereo_type", this.stereoType);
        }
        if (this.merchantProductId != null) {
            map.put("merchant_product_id", this.merchantProductId);
        }
        return map;
    }

    public HttpUtils.FileParam toFileParam() {
        HttpUtils.FileParam fileParam = new HttpUtils.FileParam();
        fileParam.setParam("cover");
        fileParam.setFile(this.cover);
        return fileParam;
    }
}

