/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.kwai.open.model.VideoInfo;
import com.github.kwai.open.response.BaseResponse;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class VideoListResponse
extends BaseResponse {
    @JsonProperty(value="video_list")
    private List<VideoInfo> videoList;
    private String lastCursor;

    public List<VideoInfo> getVideoList() {
        return this.videoList;
    }

    public void setVideoList(List<VideoInfo> videoList) {
        this.videoList = videoList.stream().sorted(Comparator.comparing(VideoInfo::getCreateTime).reversed()).collect(Collectors.toList());
    }

    public String getLastCursor() {
        if (this.lastCursor == null) {
            if (this.videoList == null || this.videoList.size() == 0) {
                this.lastCursor = "";
                return this.lastCursor;
            }
            this.lastCursor = this.videoList.stream().sorted(Comparator.comparing(VideoInfo::getCreateTime)).findFirst().map(VideoInfo::getPhotoId).orElse("");
        }
        return this.lastCursor;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("VideoListResponse{");
        sb.append("videoList=").append(this.videoList);
        sb.append(", lastCursor='").append(this.getLastCursor()).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

