/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.utils;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.KwaiOpenResultCode;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtils {
    private static final String CBC_AES_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static Cipher cipher;

    public static byte[] decrypt(byte[] aesKey, byte[] iv, String base64EncodeData) throws KwaiOpenException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            byte[] data = Base64.decodeBase64((String)base64EncodeData);
            Cipher cipher = AESUtils.getCipher();
            byte[] decryptBytes = AESUtils.decrypt(cipher, data, keySpec, ivSpec);
            return decryptBytes;
        }
        catch (Exception e) {
            throw new KwaiOpenException(KwaiOpenResultCode.SERVER_ERROR, "AES\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    private static byte[] decrypt(Cipher cipher, byte[] cipherData, SecretKeySpec keySpec, IvParameterSpec ivSpec) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (cipherData.length == 0) {
            return cipherData;
        }
        cipher.init(2, (Key)keySpec, ivSpec);
        return cipher.doFinal(cipherData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Cipher getCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        if (cipher != null) return cipher;
        Class<AESUtils> clazz = AESUtils.class;
        synchronized (AESUtils.class) {
            if (cipher != null) return cipher;
            cipher = Cipher.getInstance(CBC_AES_ALGORITHM);
            // ** MonitorExit[var0] (shouldn't be in output)
            return cipher;
        }
    }
}

