/*
 * Decompiled with CFR 0.152.
 */
package com.github.liangbaika.validate.core;

import com.github.liangbaika.validate.annations.ValidateParam;
import com.github.liangbaika.validate.annations.ValidateParams;
import com.github.liangbaika.validate.exception.ParamsCheckException;
import com.github.liangbaika.validate.exception.ParamsInValidException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CheckParamAop {
    @Pointcut(value="@annotation(com.github.liangbaika.validate.annations.ValidateParam)")
    public void checkParam() {
    }

    @Pointcut(value="@annotation(com.github.liangbaika.validate.annations.ValidateParam.List)")
    public void checkParamList() {
    }

    @Pointcut(value="@annotation(com.github.liangbaika.validate.annations.ValidateParams)")
    public void checkParams() {
    }

    @Around(value="checkParam()")
    public Object checkSingle(ProceedingJoinPoint point) throws Throwable {
        return this.interCheck(point, false, false);
    }

    @Around(value="checkParams()")
    public Object checkGroup(ProceedingJoinPoint point) throws Throwable {
        return this.interCheck(point, true, false);
    }

    @Around(value="checkParamList()")
    public Object checkList(ProceedingJoinPoint point) throws Throwable {
        return this.interCheck(point, true, true);
    }

    private Object interCheck(ProceedingJoinPoint point, boolean muiti, boolean special) throws Throwable {
        SampleResult sampleResult = this.doCheck((JoinPoint)point, muiti, special);
        if (!sampleResult.getPass().booleanValue()) {
            throw new ParamsInValidException(sampleResult.getMsg());
        }
        Object obj = point.proceed();
        return obj;
    }

    private SampleResult doCheck(JoinPoint point, boolean multi, boolean special) {
        Method method = this.getMethod(point);
        String[] paramName = this.getParamName(point);
        Object[] arguments = point.getArgs();
        Boolean isValid = true;
        String msg = " ";
        if (multi) {
            ArrayList list = new ArrayList();
            List annoModels = null;
            ValidateParams annotation = null;
            if (special) {
                ValidateParam.List annotationList = method.getAnnotation(ValidateParam.List.class);
                annoModels = Arrays.stream(annotationList.value()).map(e -> new AnnoModel(true, (ValidateParam)e)).collect(Collectors.toList());
            } else {
                annotation = method.getAnnotation(ValidateParams.class);
                annoModels = Arrays.stream(annotation.value()).map(e -> new AnnoModel(false, (ValidateParam)e)).collect(Collectors.toList());
            }
            assert (annoModels.size() > 0);
            list.addAll(annoModels);
            boolean shortPath = false;
            boolean anded = true;
            if (annotation != null) {
                shortPath = annotation.shortPath();
                anded = annotation.anded();
            }
            int passCounter = 0;
            for (AnnoModel annoModel : list) {
                ValidateParam anno = annoModel.getValidateParam();
                boolean required = anno.required();
                String argName = anno.argName();
                Object value = this.getParamValue(arguments, paramName, argName);
                if (!required && value == null) continue;
                Boolean tmpValid = anno.value().fun.apply(value, anno.express());
                if (tmpValid.booleanValue() && !annoModel.getSed().booleanValue()) {
                    ++passCounter;
                }
                if (isValid.booleanValue()) {
                    isValid = tmpValid;
                }
                if (tmpValid.booleanValue()) continue;
                String tmpMsg = anno.msg();
                msg = msg + "  " + tmpMsg;
                if ("".equals(tmpMsg)) {
                    msg = msg + "  " + argName + ": " + anno.value().msg + " " + anno.express() + " ; ";
                }
                if (!shortPath) continue;
                break;
            }
            if (!special && !anded && passCounter > 0) {
                msg = msg + " \u6761\u4ef6[\u6216] ";
            }
            if (!anded && list.size() > 1 && passCounter > 0) {
                isValid = true;
            }
        } else {
            ValidateParam anno = method.getAnnotation(ValidateParam.class);
            boolean required = anno.required();
            String argName = anno.argName();
            Object value = this.getParamValue(arguments, paramName, argName);
            if (required || value != null) {
                isValid = anno.value().fun.apply(value, anno.express());
                msg = anno.msg();
                if ("".equals(msg)) {
                    msg = argName + ": " + anno.value().msg + " " + anno.express();
                }
            }
        }
        return new SampleResult(msg, isValid);
    }

    private String[] getParamName(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        return methodSignature.getParameterNames();
    }

    private Object getParamValue(Object[] arguments, String[] paramName, String argName) {
        Object value = null;
        String name = argName;
        String spliter = ".";
        if (argName.contains(spliter)) {
            name = argName.split("\\.")[0];
        }
        int index = 0;
        for (String string : paramName) {
            if (string.equals(name)) {
                value = arguments[index];
                break;
            }
            ++index;
        }
        if (argName.contains(spliter)) {
            String[] argNames = argName.split("\\.");
            try {
                if (argNames != null && argNames.length > 10) {
                    throw new ParamsCheckException(String.format(" occured validated raw error   argName {%s} the recursion is too deep,over 10..  ", argName));
                }
                value = CheckParamAop.getObjValue(1, value, argNames);
            }
            catch (NoSuchMethodException e) {
                throw new ParamsCheckException(String.format(" occured validated raw error NoSuchMethodException  argName {%s} can not  found getter method  e is {%s}", argName, e.getMessage()));
            }
            catch (InvocationTargetException e) {
                throw new ParamsCheckException(String.format("occured validated raw error InvocationTargetException  argName {%s} invoke getter method error  e is {%s}", argName, e.getMessage()));
            }
            catch (IllegalAccessException e) {
                throw new ParamsCheckException(String.format("  validated raw error argName {%s} when get filed value IllegalAccessException occured   e is {%s}", argName, e.getMessage()));
            }
        }
        return value;
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Object getObjValue(int index, Object value, String[] argNames) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        assert (index > 0);
        assert (argNames != null);
        if (index >= argNames.length || value == null) {
            return value;
        }
        String tempName = argNames[index];
        String suffix = tempName.substring(0, 1).toUpperCase() + tempName.substring(1);
        String filedMethodName = "get" + suffix;
        boolean has = CheckParamAop.hasThisMethodByName(value, filedMethodName);
        if (!has) {
            filedMethodName = "is" + suffix;
        }
        Method getterMethod = value.getClass().getMethod(filedMethodName, new Class[0]);
        Object tempValue = getterMethod.invoke(value, new Object[0]);
        return CheckParamAop.getObjValue(index + 1, tempValue, argNames);
    }

    private static boolean hasThisMethodByName(Object obj, String filedMethodName) {
        if (obj == null || filedMethodName == null) {
            return false;
        }
        Method[] methods = obj.getClass().getMethods();
        if (methods == null || methods.length <= 0) {
            return false;
        }
        for (Method method : methods) {
            if (!filedMethodName.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    private static class AnnoModel {
        private Boolean sed;
        private ValidateParam validateParam;

        public AnnoModel(boolean sed, ValidateParam validateParam) {
            this.sed = sed;
            this.validateParam = validateParam;
        }

        public Boolean getSed() {
            return this.sed;
        }

        public ValidateParam getValidateParam() {
            return this.validateParam;
        }
    }

    private static class SampleResult {
        private String msg;
        private Boolean pass;

        public SampleResult(String msg, Boolean pass) {
            this.msg = msg;
            this.pass = pass;
        }

        public String getMsg() {
            return this.msg;
        }

        public Boolean getPass() {
            return this.pass;
        }
    }
}

