/*
 * Decompiled with CFR 0.152.
 */
package com.github.liangbaika.validate.core;

import com.github.liangbaika.validate.enums.Check;
import com.github.liangbaika.validate.exception.ParamsCheckException;
import com.github.liangbaika.validate.exception.ParamsInValidException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ValidateBuilder {
    private List<ValidateChain> chains = new ArrayList<ValidateChain>();

    private ValidateBuilder() {
    }

    public ValidateBuilder vali(Check check, Object value, String express, String msg) {
        ValidateChain validateChain = new ValidateChain();
        validateChain.setCheck(check);
        validateChain.setValue(value);
        validateChain.setExpress(express);
        validateChain.setMsg(msg == null || Objects.equals(msg, "") ? check.msg : msg);
        this.chains.add(validateChain);
        return this;
    }

    public ValidateBuilder vali(Check check, Object value, String msg) {
        return this.vali(check, value, null, msg);
    }

    public ValidateBuilder vali(Check check, Object value) {
        return this.vali(check, value, null, null);
    }

    public ValidateBuilder wvali(Check check, Object value, String express) {
        return this.vali(check, value, express, null);
    }

    public ValidateBuilder doCheck() {
        for (ValidateChain conn : this.chains) {
            Boolean result = conn.getCheck().vali(conn.value, conn.express);
            conn.setResult(result);
        }
        return this;
    }

    public Boolean isPassed() {
        if (this.chains == null || this.chains.isEmpty()) {
            throw new ParamsCheckException("chains can not be empty, please call methods  'vali' and 'doCheck' first");
        }
        List faileds = this.chains.stream().filter(e -> Boolean.FALSE.equals(e.getResult())).collect(Collectors.toList());
        return faileds.size() <= 0;
    }

    public ValidateBuilder ifNotPassedThrowException() {
        return this.ifNotPassedThrowException(null);
    }

    public ValidateBuilder ifNotPassedThrowException(RuntimeException e) {
        Boolean passed = this.isPassed();
        if (e == null) {
            e = new ParamsInValidException(this.getFailedMsgs());
        }
        if (!passed.booleanValue()) {
            throw e;
        }
        return this;
    }

    public String getFailedMsgs() {
        if (this.chains == null || this.chains.isEmpty()) {
            return null;
        }
        String failedMsgs = this.chains.stream().filter(e -> Boolean.FALSE.equals(e.getResult())).map(e -> e.getValue() + " " + e.getMsg() + " " + (e.getExpress() == null ? "" : e.getExpress())).collect(Collectors.joining(","));
        return "".equals(failedMsgs) ? null : failedMsgs;
    }

    public int getFailedCounts() {
        if (this.chains == null || this.chains.isEmpty()) {
            return 0;
        }
        return this.chains.stream().filter(e -> Boolean.FALSE.equals(e.getResult())).collect(Collectors.toList()).size();
    }

    public int getSuccedCounts() {
        return this.chains.size() - this.getFailedCounts();
    }

    public List<ValidateChain> getChains() {
        return this.chains;
    }

    public static ValidateBuilder build() {
        return new ValidateBuilder();
    }

    public ValidateBuilder clear() {
        this.chains.clear();
        return this;
    }

    public static class ValidateChain {
        private Check check;
        private Object value;
        private String express;
        private Boolean result;
        private String msg;

        public Check getCheck() {
            return this.check;
        }

        public void setCheck(Check check) {
            this.check = check;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String getExpress() {
            return this.express;
        }

        public void setExpress(String express) {
            this.express = express;
        }

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

