/*
 * Decompiled with CFR 0.152.
 */
package com.github.liangbaika.validate.enums;

import com.github.liangbaika.validate.utils.CheckUtil;
import java.util.function.BiFunction;

public enum Check {
    Custom("\u53c2\u6570\u9a8c\u8bc1\u4e0d\u901a\u8fc7", CheckUtil::customValidate),
    Null("\u53c2\u6570\u5fc5\u987b\u4e3a\u7a7a", CheckUtil::isNull),
    NotNull("\u53c2\u6570\u5fc5\u987b\u4e0d\u4e3a\u7a7a", CheckUtil::isNotNull),
    Empty("\u53c2\u6570\u7684\u5fc5\u987b\u4e3a\u7a7a", CheckUtil::isEmpty),
    NotEmpty("\u53c2\u6570\u5fc5\u987b\u975e\u7a7a", CheckUtil::isNotEmpty),
    True("\u53c2\u6570\u5fc5\u987b\u4e3a true", CheckUtil::isTrue),
    False("\u53c2\u6570\u5fc5\u987b\u4e3a false", CheckUtil::isFalse),
    Date("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u65e5\u671f yyyy-MM-dd", CheckUtil::isDate),
    DateTime("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u65e5\u671f\u65f6\u95f4 yyyy-MM-dd HH:mm:ss", CheckUtil::isDateTime),
    TimeMillSeconds("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u65f6\u95f4\u6beb\u79d2\u503c", CheckUtil::isTimeMillSeconds),
    Past("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u8fc7\u53bb\u7684\u65e5\u671f", CheckUtil::isPast),
    Future("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u5c06\u6765\u7684\u65e5\u671f", CheckUtil::isFuture),
    Today("\u53c2\u6570\u5fc5\u987b\u4eca\u5929\u7684\u65e5\u671f", CheckUtil::isToday),
    Enum("\u53c2\u6570\u5fc5\u987b\u5728\u679a\u4e3e\u4e2d", CheckUtil::inEnum),
    Email("\u53c2\u6570\u5fc5\u987b\u662fEmail\u5730\u5740", CheckUtil::isEmail),
    MobilePhone("\u53c2\u6570\u5fc5\u987b\u662f\u624b\u673a\u53f7", CheckUtil::isMobilePhone),
    Number("\u53c2\u6570\u5fc5\u987b\u662f\u6570\u5b57\u7c7b\u578b", CheckUtil::isNumber),
    Range("\u53c2\u6570\u5fc5\u987b\u5728\u5408\u9002\u7684\u8303\u56f4\u5185", CheckUtil::inRange),
    NotIn("\u53c2\u6570\u5fc5\u987b\u4e0d\u5728\u6307\u5b9a\u7684\u8303\u56f4\u5185", CheckUtil::outRange),
    Length("\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u5728\u6307\u5b9a\u8303\u56f4\u5185", CheckUtil::inLength),
    gt("\u53c2\u6570\u5fc5\u987b\u5927\u4e8e\u6307\u5b9a\u503c", CheckUtil::isGreaterThan),
    lt("\u53c2\u6570\u5fc5\u987b\u5c0f\u4e8e\u6307\u5b9a\u503c", CheckUtil::isLessThan),
    ge("\u53c2\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6307\u5b9a\u503c", CheckUtil::isGreaterThanEqual),
    le("\u53c2\u6570\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6307\u5b9a\u503c", CheckUtil::isLessThanEqual),
    ne("\u53c2\u6570\u5fc5\u987b\u4e0d\u7b49\u4e8e\u6307\u5b9a\u503c", CheckUtil::isNotEqual),
    eq("\u53c2\u6570\u5fc5\u987b\u7b49\u4e8e\u6307\u5b9a\u503c", CheckUtil::isEqual),
    Pattern("\u53c2\u6570\u5fc5\u987b\u7b26\u5408\u6307\u5b9a\u7684\u6b63\u5219\u8868\u8fbe\u5f0f", CheckUtil::isPattern),
    Chinese("\u53c2\u6570\u5fc5\u987b\u662f\u6c49\u5b57", CheckUtil::isChinese),
    isUrl("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u5b8c\u6574\u7684url", CheckUtil::isUrl),
    isISBN("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u4e66\u7c4dISBN\u7f16\u53f7", CheckUtil::isISBN),
    isBankNumber("\u53c2\u6570\u5fc5\u987b\u662f\u4e00\u4e2a\u94f6\u884c\u5361\u53f7", CheckUtil::isBankNumber),
    isChinesePostCode("\u53c2\u6570\u5fc5\u987b\u662f\u4e2d\u56fd\u90ae\u7f16", CheckUtil::isChinesePostCode),
    isPlateNumber("\u53c2\u6570\u5fc5\u987b\u662f\u4e2d\u56fd\u8f66\u724c\u53f7", CheckUtil::isPlateNumber),
    isUUID("\u53c2\u6570\u5fc5\u987b\u662fUUID", CheckUtil::isUUID),
    isIpv4("\u53c2\u6570\u5fc5\u987b\u662fipv4", CheckUtil::isIpv4),
    isIpv6("\u53c2\u6570\u5fc5\u987b\u662fipv6", CheckUtil::isIpv6),
    isMac("\u53c2\u6570\u5fc5\u987b\u662fmac\u5730\u5740", CheckUtil::isMac),
    isIDCard("\u53c2\u6570\u5fc5\u987b\u662f\u8eab\u4efd\u8bc1", CheckUtil::isIdCard),
    isGeneral("\u53c2\u6570\u5fc5\u987b\u662f\u82f1\u6587\u5b57\u6bcd,\u6570\u5b57\u548c\u4e0b\u5212\u7ebf", CheckUtil::isGeneral),
    isBirthdaystr("\u53c2\u6570\u5fc5\u987b\u662f\u751f\u65e5\u5b57\u7b26\u4e32\u683c\u5f0f", CheckUtil::isBirthday),
    isSuitableFileLength("\u6587\u4ef6\u592a\u5927\u5566", CheckUtil::isSuitableFileLength),
    isSuitableFileSuffix("\u6587\u4ef6\u5fc5\u987b\u662f\u6709\u6548\u5408\u6cd5\u540e\u7f00\u7684\u6587\u4ef6", CheckUtil::isSuitableFileSuffix);

    public String msg;
    public BiFunction<Object, String, Boolean> fun;

    private Check(String msg, BiFunction<Object, String, Boolean> fun) {
        this.msg = msg;
        this.fun = fun;
    }

    public Boolean vali(Object value, String express) {
        return this.fun.apply(value, express);
    }

    public Boolean vali(Object value) {
        return this.vali(value, null);
    }
}

