/*
 * Decompiled with CFR 0.152.
 */
package com.github.liangbaika.validate.utils;

import com.github.liangbaika.validate.core.ParamValidator;
import com.github.liangbaika.validate.exception.ParamsCheckException;
import com.github.liangbaika.validate.utils.SpringContextHolder;
import java.io.File;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.web.multipart.MultipartFile;

public class CheckUtil {
    public static Boolean customValidate(Object value, String beanName) {
        ParamValidator bean = (ParamValidator)SpringContextHolder.getBean(beanName);
        if (bean == null) {
            throw new IllegalArgumentException("invalied bean, this bean can not  found in spring context");
        }
        Function<Object, Boolean> func = bean::validate;
        return func.apply(value);
    }

    public static Boolean isNull(Object value, String express) {
        if (null != value) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isMobilePhone(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        return RegexPattern.MOBILE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isNumber(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        if (value instanceof Number) {
            return Boolean.TRUE;
        }
        return RegexPattern.NUMBER_CODE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isNotNull(Object value, String express) {
        if (null == value) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isEmpty(Object value, String express) {
        return CheckUtil.isNotEmpty(value, express) == false;
    }

    public static Boolean isNotEmpty(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String && "".equals(((String)value).trim())) {
            return Boolean.FALSE;
        }
        if (value instanceof Collection && (value == null || ((Collection)value).size() == 0)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isTrue(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            try {
                return Boolean.parseBoolean((String)value);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    public static Boolean isFalse(Object value, String express) {
        return CheckUtil.isTrue(value, express) == false;
    }

    public static Boolean isDate(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDate.parse(v, DateTimeFormatter.ofPattern(express));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return Boolean.TRUE;
        }
        if (value instanceof LocalDate) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isDateTime(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return Boolean.TRUE;
        }
        if (value instanceof LocalDateTime) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isPast(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime ldt = LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDateTime.now().isAfter(ldt);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().after((Date)value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().isAfter((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now().isAfter((LocalDateTime)value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isFuture(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDateTime ldt = LocalDateTime.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDateTime.now().isBefore(ldt);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().before((Date)value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().isBefore((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTime.now().isBefore((LocalDateTime)value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isToday(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (express == null || "".equals(express)) {
            express = "yyyy-MM-dd HH:mm:ss";
        }
        if (value instanceof String) {
            String v = (String)value;
            try {
                LocalDate ld = LocalDate.parse(v, DateTimeFormatter.ofPattern(express));
                return LocalDate.now().equals(ld);
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        if (value instanceof Date) {
            return new Date().equals(value);
        }
        if (value instanceof LocalDate) {
            return LocalDate.now().equals(value);
        }
        return Boolean.FALSE;
    }

    public static Boolean isEmail(Object value, String express) {
        if (CheckUtil.isNull(value, express).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String) {
            return RegexPattern.EMAIL.matcher(String.valueOf(value)).matches();
        }
        return Boolean.FALSE;
    }

    public static Boolean inRange(Object value, String rangeStr) {
        if (CheckUtil.isNull(value, rangeStr).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == rangeStr || "".equals(rangeStr)) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            Integer begin = Integer.valueOf(rangeStr.split(",")[0]);
            Integer end = Integer.valueOf(rangeStr.split(",")[1]);
            Integer v = (Integer)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Long) {
            Long begin = Long.valueOf(rangeStr.split(",")[0]);
            Long end = Long.valueOf(rangeStr.split(",")[1]);
            Long v = (Long)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Short) {
            Short begin = Short.valueOf(rangeStr.split(",")[0]);
            Short end = Short.valueOf(rangeStr.split(",")[1]);
            Short v = (Short)value;
            return begin <= v && v <= end;
        }
        if (value instanceof Float) {
            Float begin = Float.valueOf(rangeStr.split(",")[0]);
            Float end = Float.valueOf(rangeStr.split(",")[1]);
            Float v = (Float)value;
            return begin.floatValue() <= v.floatValue() && v.floatValue() <= end.floatValue();
        }
        if (value instanceof Double) {
            Double begin = Double.valueOf(rangeStr.split(",")[0]);
            Double end = Double.valueOf(rangeStr.split(",")[1]);
            Double v = (Double)value;
            return begin <= v && v <= end;
        }
        if (value instanceof BigDecimal) {
            BigDecimal begin = new BigDecimal(rangeStr.split(",")[0]);
            BigDecimal end = new BigDecimal(rangeStr.split(",")[1]);
            BigDecimal v = (BigDecimal)value;
            return begin.compareTo(v) <= 0 && v.compareTo(end) <= 0;
        }
        return Boolean.FALSE;
    }

    public static Boolean outRange(Object value, String rangeStr) {
        return CheckUtil.inRange(value, rangeStr) == false;
    }

    public static Boolean inLength(Object value, String rangeStr) {
        if (CheckUtil.isNull(value, rangeStr).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == rangeStr || "".equals(rangeStr)) {
            return Boolean.FALSE;
        }
        String spliter = ",";
        if (value instanceof String) {
            Integer begin = null;
            Integer end = null;
            begin = !rangeStr.contains(spliter) ? Integer.valueOf(0) : Integer.valueOf(rangeStr.split(spliter)[0]);
            end = begin == 0 ? Integer.valueOf(rangeStr) : Integer.valueOf(rangeStr.split(spliter)[1]);
            Integer v = ((String)value).length();
            return begin <= v && v <= end;
        }
        return Boolean.FALSE;
    }

    public static Boolean inEnum(Object value, String enumStr) {
        if (CheckUtil.isNull(value, null).booleanValue()) {
            return Boolean.FALSE;
        }
        if (null == enumStr || "".equals(enumStr)) {
            return Boolean.FALSE;
        }
        String[] array = enumStr.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
        return set.contains(value.toString());
    }

    public static Boolean isGreaterThan(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value > Integer.valueOf(express);
        }
        if (value instanceof Long) {
            return (Long)value > Long.valueOf(express);
        }
        if (value instanceof Short) {
            return (Short)value > Short.valueOf(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() > Float.valueOf(express).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value > Double.valueOf(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) > 0;
        }
        if (value instanceof String) {
            return ((String)value).length() > Integer.valueOf(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() > Integer.valueOf(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isGreaterThanEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value >= Integer.valueOf(express);
        }
        if (value instanceof Long) {
            return (Long)value >= Long.valueOf(express);
        }
        if (value instanceof Short) {
            return (Short)value >= Short.valueOf(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() >= Float.valueOf(express).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value >= Double.valueOf(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) >= 0;
        }
        if (value instanceof String) {
            return ((String)value).length() >= Integer.valueOf(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() >= Integer.valueOf(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isLessThan(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value < Integer.valueOf(express);
        }
        if (value instanceof Long) {
            return (Long)value < Long.valueOf(express);
        }
        if (value instanceof Short) {
            return (Short)value < Short.valueOf(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() < Float.valueOf(express).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value < Double.valueOf(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) < 0;
        }
        if (value instanceof String) {
            return ((String)value).length() < Integer.valueOf(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() < Integer.valueOf(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isLessThanEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof Integer) {
            return (Integer)value <= Integer.valueOf(express);
        }
        if (value instanceof Long) {
            return (Long)value <= Long.valueOf(express);
        }
        if (value instanceof Short) {
            return (Short)value <= Short.valueOf(express);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue() <= Float.valueOf(express).floatValue();
        }
        if (value instanceof Double) {
            return (Double)value <= Double.valueOf(express);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) <= 0;
        }
        if (value instanceof String) {
            return ((String)value).length() <= Integer.valueOf(express);
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() <= Integer.valueOf(express);
        }
        return Boolean.FALSE;
    }

    public static Boolean isNotEqual(Object value, String express) {
        return CheckUtil.isEqual(value, express) == false;
    }

    public static Boolean isSuitableFileLength(Object value, String express) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        ArrayList<Long> lens = new ArrayList<Long>();
        if (value instanceof File || value instanceof MultipartFile) {
            CheckUtil.judgeLen(value, lens);
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(e -> CheckUtil.judgeLen(e, lens));
        }
        if (value.getClass().isArray()) {
            Object[] objs = (Object[])value;
            for (int i = 0; i < objs.length; ++i) {
                Object tmpvalue = objs[i];
                CheckUtil.judgeLen(tmpvalue, lens);
            }
        }
        if (lens.size() == 0) {
            return Boolean.FALSE;
        }
        return CheckUtil.realJudgeFileLen(lens, express);
    }

    private static Boolean realJudgeFileLen(List<Long> lens, String express) {
        long defaultLen = RegexPattern.DEFAULT_FILE_SIZE;
        if (express != null && !"".equals(express)) {
            defaultLen = Long.parseLong(express);
        }
        for (Long len : lens) {
            if (len / 1024L <= defaultLen) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isSuitableFileSuffix(Object value, String express) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        ArrayList names = new ArrayList();
        if (value instanceof File || value instanceof MultipartFile || value instanceof String) {
            CheckUtil.judge(value, names);
        }
        if (value instanceof Collection) {
            ((Collection)value).forEach(e -> CheckUtil.judge(e, names));
        }
        if (value.getClass().isArray()) {
            Object[] objs = (Object[])value;
            for (int i = 0; i < objs.length; ++i) {
                Object tmpvalue = objs[i];
                CheckUtil.judge(tmpvalue, names);
            }
        }
        if (names.size() == 0) {
            return Boolean.FALSE;
        }
        return CheckUtil.realJudgeFileSuffix(names, express);
    }

    private static Boolean realJudgeFileSuffix(List names, String express) {
        String[] suffixs = null;
        suffixs = express != null && !"".equals(express) ? express.split(",") : RegexPattern.DEFAULT_ALLOWED_EXTENSION;
        List<String> suffixList = Arrays.asList(suffixs);
        for (Object fileName : names) {
            String fileName1 = (String)fileName;
            if (fileName1.contains(".")) {
                String fileSuffix = fileName1.split("\\.")[1];
                if (fileSuffix != null && suffixList.contains(fileSuffix)) continue;
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static void judgeLen(Object tmpvalue, List names) {
        if (tmpvalue instanceof File) {
            long length = ((File)tmpvalue).length();
            names.add(length);
        } else if (tmpvalue instanceof MultipartFile) {
            long size = ((MultipartFile)tmpvalue).getSize();
            names.add(size);
        } else {
            throw new ParamsCheckException("the field type is wrong, we need a File or  MultipartFile ");
        }
    }

    private static void judge(Object tmpvalue, List names) {
        if (tmpvalue instanceof File) {
            String filename = ((File)tmpvalue).getName();
            names.add(filename);
        } else if (tmpvalue instanceof MultipartFile) {
            String filename = ((MultipartFile)tmpvalue).getOriginalFilename();
            names.add(filename);
        } else if (tmpvalue instanceof String) {
            names.add(tmpvalue);
        } else {
            throw new ParamsCheckException("the field type is wrong, we need a File or  MultipartFile or String ");
        }
    }

    public static Boolean isEqual(Object value, String express) {
        if (value == null) {
            return Boolean.FALSE;
        }
        if (value instanceof String) {
            return ((String)value).equals(express);
        }
        if (value instanceof Integer) {
            return ((Integer)value).equals(Integer.valueOf(express));
        }
        if (value instanceof Long) {
            return ((Long)value).equals(Long.valueOf(express));
        }
        if (value instanceof Short) {
            return ((Short)value).equals(Short.valueOf(express));
        }
        if (value instanceof Float) {
            return ((Float)value).equals(Float.valueOf(express));
        }
        if (value instanceof Double) {
            return ((Double)value).equals(Double.valueOf(express));
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(new BigDecimal(express)) == 0;
        }
        if (value instanceof Collection) {
            return ((Collection)value).size() == Integer.valueOf(express).intValue();
        }
        return Boolean.FALSE;
    }

    public static Boolean isPattern(Object value, String regEx) {
        Pattern p;
        Matcher m;
        if (CheckUtil.isNull(value, null).booleanValue()) {
            return Boolean.FALSE;
        }
        if (value instanceof String && (m = (p = Pattern.compile(regEx)).matcher((String)value)).matches()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isTimeMillSeconds(Object value, String regEx) {
        Boolean number = CheckUtil.isNumber(value, regEx);
        if (number.booleanValue() && String.valueOf(value).length() == 13) {
            return true;
        }
        return false;
    }

    public static Boolean isIdCard(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CITIZEN_ID.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isChinesePostCode(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.ZIP_CODE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isIpv4(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.IPV4.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isIpv6(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.IPV6.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isChinese(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.CHINESES.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isGeneral(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.GENERAL.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isMac(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.MAC_ADDRESS.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isPlateNumber(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.PLATE_NUMBER.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isUrl(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        try {
            new URL(String.valueOf(value));
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static Boolean isISBN(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.ISBN_REGEX.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isBankNumber(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        String number = String.valueOf(value);
        if (number.length() != 16 && number.length() != 19) {
            return false;
        }
        if (!number.matches("\\d+")) {
            return false;
        }
        char[] digits = number.toCharArray();
        int len = number.length();
        int numSum = 0;
        int i = len - 1;
        int j = 1;
        while (i >= 0) {
            int value0 = digits[i] - 48;
            if (j % 2 == 0 && (value0 *= 2) > 9) {
                value0 -= 9;
            }
            numSum += value0;
            --i;
            ++j;
        }
        return numSum % 10 == 0;
    }

    public static Boolean isUUID(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return RegexPattern.UUID.matcher(String.valueOf(value)).matches() || RegexPattern.UUID_SIMPLE.matcher(String.valueOf(value)).matches();
    }

    public static Boolean isBirthday(Object value, String regEx) {
        if (value == null) {
            return Boolean.FALSE;
        }
        Matcher matcher = RegexPattern.BIRTHDAY.matcher(String.valueOf(value));
        if (matcher.find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            Calendar calendar = Calendar.getInstance();
            int thisYear = calendar.get(1);
            if (year < 1900 || year > thisYear) {
                return false;
            }
            if (month < 1 || month > 12) {
                return false;
            }
            if (day < 1 || day > 31) {
                return false;
            }
            if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static class RegexPattern {
        public static final Pattern EMAIL = Pattern.compile("^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");
        public static final Pattern GENERAL = Pattern.compile("^\\w+$");
        public static final Pattern CHINESES = Pattern.compile("[\u4e00-\u9fff]+");
        public static final Pattern IPV4 = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        public static final Pattern IPV6 = Pattern.compile("(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4})?:)?((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))");
        public static final Pattern MONEY = Pattern.compile("^(\\d+(?:\\.\\d+)?)$");
        public static final Pattern MOBILE = Pattern.compile("(?:0|86|\\+86)?1[3456789]\\d{9}");
        public static final Pattern CITIZEN_ID = Pattern.compile("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([012]\\d)|3[0-1])\\d{3}(\\d|X|x)");
        public static final Pattern ZIP_CODE = Pattern.compile("[1-9]\\d{5}(?!\\d)");
        public static final Pattern BIRTHDAY = Pattern.compile("^(\\d{2,4})([/\\-.\u5e74]?)(\\d{1,2})([/\\-.\u6708]?)(\\d{1,2})\u65e5?$");
        public static final Pattern GENERAL_WITH_CHINESE = Pattern.compile("^[\u4e00-\u9fff\\w]+$");
        public static final Pattern ISBN_REGEX = Pattern.compile("^(?:ISBN(?:-1[03])?:? )?(?=[0-9X]{10}$|(?=(?:[0-9]+[- ]){3})[- 0-9X]{13}$|97[89][0-9]{10}$|(?=(?:[0-9]+[- ]){4})[- 0-9]{17}$)(?:97[89][- ]?)?[0-9]{1,5}[- ]?[0-9]+[- ]?[0-9]+[- ]?[0-9X]$");
        public static final Pattern UUID = Pattern.compile("^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$");
        public static final Pattern UUID_SIMPLE = Pattern.compile("^[0-9a-z]{32}$");
        public static final Pattern MAC_ADDRESS = Pattern.compile("((?:[A-F0-9]{1,2}[:-]){5}[A-F0-9]{1,2})|(?:0x)(\\d{12})(?:.+ETHER)", 2);
        public static final String[] DEFAULT_ALLOWED_EXTENSION = new String[]{"bmp", "gif", "jpg", "jpeg", "png", "blob", "webp", "svg", "pcx", "ico", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "html", "htm", "txt", "rar", "zip", "gz", "bz2", "7z", "tar.gz", "xml", "pdf", "swf", "flv", "mp3", "wav", "wma", "wmv", "mid", "avi", "mpg", "asf", "rm", "rmvb", "mp4", "mov"};
        public static final Pattern PLATE_NUMBER = Pattern.compile("^(([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z](([0-9]{5}[ABCDEFGHJK])|([ABCDEFGHJK]([A-HJ-NP-Z0-9])[0-9]{4})))|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886]\\d{3}\\d{1,3}[\u9886])|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z][A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3\u4f7f\u9886]))$");
        public static final Pattern CREDIT_CODE = Pattern.compile("^[0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}$");
        public static final Pattern NUMBER_CODE = Pattern.compile("\\d+(\\.\\d+)?");
        public static final Long DEFAULT_FILE_SIZE = 0xA00000L;
    }
}

