/*
 * Decompiled with CFR 0.152.
 */
package com.github.liangbaika.validate.utils;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextHolder
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertApplicationContext(null, null);
        return applicationContext;
    }

    public static <T> T getBean(String beanName) {
        SpringContextHolder.assertApplicationContext(beanName, null);
        return (T)applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertApplicationContext(null, requiredType);
        return (T)applicationContext.getBean(requiredType);
    }

    private static void assertApplicationContext(String beanName, Class requiredType) {
        boolean have;
        if (applicationContext == null) {
            throw new RuntimeException("ApplicaitonContext property is NULL, please check whether SpringContextHolder is injected!");
        }
        if (beanName != null && !(have = applicationContext.containsBean(beanName))) {
            throw new RuntimeException("This bean is not managed by the Spring container  ");
        }
        if (requiredType != null) {
            String[] beanNamesForType = applicationContext.getBeanNamesForType(requiredType);
            if (beanNamesForType == null || beanNamesForType.length == 0) {
                throw new RuntimeException("This bean is not managed by the Spring container  ");
            }
            if (beanNamesForType.length != 1) {
                throw new RuntimeException("Class type fetching is not supported for multiple types of beans. Use the name to get this bean");
            }
            boolean have2 = applicationContext.containsBean(beanNamesForType[0]);
            if (!have2) {
                throw new RuntimeException("This bean is not managed by the Spring container ");
            }
        }
    }
}

