/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.core.reactive;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Rxjava3CompletableCallAdapterFactory
extends CallAdapter.Factory {
    public static final Rxjava3CompletableCallAdapterFactory INSTANCE = new Rxjava3CompletableCallAdapterFactory();

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (Rxjava3CompletableCallAdapterFactory.getRawType((Type)returnType) != Completable.class) {
            return null;
        }
        return new NonBodyCallAdapter();
    }

    private Rxjava3CompletableCallAdapterFactory() {
    }

    private static class NonBodyCallAdapter<R>
    implements CallAdapter<R, Completable> {
        private NonBodyCallAdapter() {
        }

        public Type responseType() {
            return Void.class;
        }

        public Completable adapt(Call<R> call) {
            return Completable.create(emitter -> call.enqueue((Callback)new NonBodyCallBack(emitter)));
        }

        private class NonBodyCallBack
        implements Callback<R> {
            private final CompletableEmitter emitter;

            public NonBodyCallBack(CompletableEmitter emitter) {
                this.emitter = emitter;
            }

            public void onResponse(Call<R> call, Response<R> response) {
                if (response.isSuccessful()) {
                    this.emitter.onComplete();
                } else {
                    this.emitter.onError((Throwable)new HttpException(response));
                }
            }

            public void onFailure(Call<R> call, Throwable t) {
                this.emitter.onError(t);
            }
        }
    }
}

