/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;

public final class AppContextUtils {
    private static final Logger log = LoggerFactory.getLogger(AppContextUtils.class);

    public static <T> T getBeanOrNew(ApplicationContext context, Class<T> clz) {
        try {
            return (T)context.getBean(clz);
        }
        catch (Exception e1) {
            try {
                log.warn("Failed to get bean from applicationContext\uff01", (Throwable)e1);
                return clz.newInstance();
            }
            catch (Exception e2) {
                log.warn("Failed to create instance by reflection.", (Throwable)e2);
                try {
                    return (T)clz.getMethod("create", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e3) {
                    throw new RuntimeException("Failed to create instance through create static method.", e3);
                }
            }
        }
    }

    public static <T> T getTargetInstanceIfNecessary(T bean) {
        Object object = bean;
        while (AopUtils.isAopProxy(object)) {
            try {
                object = ((Advised)object).getTargetSource().getTarget();
            }
            catch (Exception e) {
                log.warn("Failed to get target source\uff01", (Throwable)e);
            }
        }
        return object;
    }

    private AppContextUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

