/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.alarm.email;

import com.github.ltsopensource.alarm.email.MailManager;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SMTPMailManagerImpl
implements MailManager {
    private String userName;
    private String password;
    private String adminAddress;
    private Properties properties;

    public SMTPMailManagerImpl(String host, String userName, String password, String adminAddress, boolean sslEnabled) {
        this(host, "", userName, password, adminAddress, sslEnabled);
    }

    public SMTPMailManagerImpl(String host, String port, String userName, String password, String adminAddress, boolean sslEnabled) {
        this.userName = userName;
        this.password = password;
        this.adminAddress = adminAddress;
        this.properties = new Properties();
        this.properties.setProperty("mail.transport.protocol", "smtp");
        this.properties.setProperty("mail.smtp.auth", "true");
        if (!StringUtils.isEmpty(host)) {
            this.properties.setProperty("mail.smtp.host", host);
        }
        if (!StringUtils.isEmpty(port)) {
            this.properties.setProperty("mail.smtp.port", port);
        }
        if (!StringUtils.isEmpty(userName)) {
            this.properties.setProperty("mail.smtp.security", "true");
        } else {
            this.properties.setProperty("mail.smtp.security", "false");
        }
        if (sslEnabled) {
            this.properties.setProperty("mail.smtp.starttls.enable", "true");
        }
    }

    private Authenticator getAuthenticator() {
        if (!StringUtils.isEmpty(this.userName)) {
            return new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPMailManagerImpl.this.userName, SMTPMailManagerImpl.this.password);
                }
            };
        }
        return null;
    }

    @Override
    public void send(String to, String title, String message) throws Exception {
        Session session = Session.getDefaultInstance((Properties)this.properties, (Authenticator)this.getAuthenticator());
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(this.adminAddress));
        mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        mimeMessage.setSubject(title);
        mimeMessage.setText(message);
        Transport.send((Message)mimeMessage);
    }
}

