/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.cmd;

import com.github.ltsopensource.cmd.HttpCmdException;
import com.github.ltsopensource.cmd.HttpCmdRequest;
import com.github.ltsopensource.cmd.HttpCmdResponse;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.commons.utils.WebUtils;
import com.github.ltsopensource.core.json.JSON;
import java.io.IOException;
import java.util.Map;

public class HttpCmd<Resp extends HttpCmdResponse>
extends HttpCmdRequest {
    public final Resp doGet(String url) throws IOException {
        HttpCmdResponse resp = null;
        String result = null;
        try {
            result = WebUtils.doGet(url, null);
        }
        catch (IOException e1) {
            try {
                resp = this.getResponseClass().newInstance();
                resp.setSuccess(false);
                resp.setMsg("GET ERROR: url=" + url + ", errorMsg=" + e1.getMessage());
                return (Resp)resp;
            }
            catch (InstantiationException e) {
                throw new HttpCmdException(e);
            }
            catch (IllegalAccessException e) {
                throw new HttpCmdException(e);
            }
        }
        if (StringUtils.isNotEmpty(result)) {
            resp = (HttpCmdResponse)JSON.parse(result, this.getResponseClass());
        }
        return (Resp)resp;
    }

    protected Class<? extends HttpCmdResponse> getResponseClass() {
        return HttpCmdResponse.class;
    }

    public Resp doPost(String url, Map<String, String> params) {
        HttpCmdResponse resp = null;
        String result = null;
        try {
            result = WebUtils.doPost(url, params, 3000, 30000);
        }
        catch (IOException e1) {
            try {
                resp = this.getResponseClass().newInstance();
                resp.setSuccess(false);
                resp.setMsg("POST ERROR: url=" + url + ", errorMsg=" + e1.getMessage());
                return (Resp)resp;
            }
            catch (InstantiationException e) {
                throw new HttpCmdException(e);
            }
            catch (IllegalAccessException e) {
                throw new HttpCmdException(e);
            }
        }
        if (StringUtils.isNotEmpty(result)) {
            resp = (HttpCmdResponse)JSON.parse(result, this.getResponseClass());
        }
        return (Resp)resp;
    }
}

