/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.constant.Constants;
import com.github.ltsopensource.core.factory.NamedThreadFactory;
import com.github.ltsopensource.core.remoting.HeartBeatMonitor;
import com.github.ltsopensource.core.remoting.RemotingClientDelegate;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.remoting.RemotingClient;
import com.github.ltsopensource.remoting.RemotingClientConfig;
import com.github.ltsopensource.remoting.RemotingProcessor;
import com.github.ltsopensource.remoting.RemotingTransporter;
import java.util.concurrent.Executors;

public abstract class AbstractClientNode<T extends Node, Context extends AppContext>
extends AbstractJobNode<T, Context> {
    protected RemotingClientDelegate remotingClient;
    private HeartBeatMonitor heartBeatMonitor;

    @Override
    protected void remotingStart() {
        this.remotingClient.start();
        this.heartBeatMonitor.start();
        RemotingProcessor defaultProcessor = this.getDefaultProcessor();
        if (defaultProcessor != null) {
            int processorSize = this.config.getParameter("lts.job.processor.thread", Constants.DEFAULT_PROCESSOR_THREAD);
            this.remotingClient.registerDefaultProcessor(defaultProcessor, Executors.newFixedThreadPool(processorSize, new NamedThreadFactory(AbstractClientNode.class.getSimpleName(), true)));
        }
    }

    protected abstract RemotingProcessor getDefaultProcessor();

    @Override
    protected void remotingStop() {
        this.heartBeatMonitor.stop();
        this.remotingClient.shutdown();
    }

    public void setNodeGroup(String nodeGroup) {
        this.config.setNodeGroup(nodeGroup);
    }

    public boolean isServerEnable() {
        return this.remotingClient.isServerEnable();
    }

    @Override
    protected void beforeRemotingStart() {
        this.remotingClient = new RemotingClientDelegate(this.getRemotingClient(new RemotingClientConfig()), this.appContext);
        this.heartBeatMonitor = new HeartBeatMonitor(this.remotingClient, this.appContext);
        this.beforeStart();
    }

    private RemotingClient getRemotingClient(RemotingClientConfig remotingClientConfig) {
        return ServiceLoader.load(RemotingTransporter.class, this.config).getRemotingClient(this.appContext, remotingClientConfig);
    }

    @Override
    protected void afterRemotingStart() {
        this.afterStart();
    }

    @Override
    protected void beforeRemotingStop() {
        this.beforeStop();
    }

    @Override
    protected void afterRemotingStop() {
        this.afterStop();
    }

    protected abstract void beforeStart();

    protected abstract void afterStart();

    protected abstract void afterStop();

    protected abstract void beforeStop();
}

