/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.NodeBuilder;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractNodeBuilder<T extends AbstractJobNode, B extends NodeBuilder>
implements NodeBuilder<T> {
    protected List<MasterChangeListener> masterChangeListeners;
    private AtomicBoolean built = new AtomicBoolean(false);
    protected String[] locations;

    public final B setPropertiesConfigure(String ... locations) {
        if (locations == null || locations.length == 0) {
            throw new IllegalArgumentException("locations can not null");
        }
        this.locations = locations;
        return (B)this;
    }

    public B addMasterChangeListener(MasterChangeListener masterChangeListener) {
        if (masterChangeListener != null) {
            if (this.masterChangeListeners == null) {
                this.masterChangeListeners = new ArrayList<MasterChangeListener>();
            }
            this.masterChangeListeners.add(masterChangeListener);
        }
        return (B)this;
    }

    private void checkLocations() {
        if (this.locations == null || this.locations.length == 0) {
            throw new IllegalArgumentException("locations can not null");
        }
    }

    @Override
    public final T build() {
        if (!this.built.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Built");
        }
        this.checkLocations();
        T node = this.build0();
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                ((AbstractJobNode)node).addMasterChangeListener(masterChangeListener);
            }
        }
        return node;
    }

    protected abstract T build0();
}

