/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.concurrent.ConcurrentHashSet;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.ListUtils;
import com.github.ltsopensource.core.listener.NodeChangeListener;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.ec.EventInfo;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SubscribedNodeManager
implements NodeChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribedNodeManager.class);
    private final ConcurrentHashMap<NodeType, Set<Node>> NODES = new ConcurrentHashMap();
    private AppContext appContext;

    public SubscribedNodeManager(AppContext appContext) {
        this.appContext = appContext;
    }

    private void addNode(Node node) {
        this._addNode(node);
    }

    private void _addNode(Node node) {
        Set<Node> nodeSet = this.NODES.get((Object)node.getNodeType());
        if (CollectionUtils.isEmpty(nodeSet)) {
            nodeSet = new ConcurrentHashSet<Node>();
            Set<Node> oldNodeList = this.NODES.putIfAbsent(node.getNodeType(), nodeSet);
            if (oldNodeList != null) {
                nodeSet = oldNodeList;
            }
        }
        nodeSet.add(node);
        EventInfo eventInfo = new EventInfo("NODE_ADD");
        eventInfo.setParam("node", node);
        this.appContext.getEventCenter().publishSync(eventInfo);
        LOGGER.info("Add {}", node);
    }

    public List<Node> getNodeList(NodeType nodeType, final String nodeGroup) {
        Set<Node> nodes = this.NODES.get((Object)nodeType);
        return ListUtils.filter(CollectionUtils.setToList(nodes), new ListUtils.Filter<Node>(){

            @Override
            public boolean filter(Node node) {
                return node.getGroup().equals(nodeGroup);
            }
        });
    }

    public List<Node> getNodeList(NodeType nodeType) {
        return CollectionUtils.setToList(this.NODES.get((Object)nodeType));
    }

    private void removeNode(Node delNode) {
        Set<Node> nodeSet = this.NODES.get((Object)delNode.getNodeType());
        if (CollectionUtils.isNotEmpty(nodeSet)) {
            for (Node node : nodeSet) {
                if (!node.getIdentity().equals(delNode.getIdentity())) continue;
                nodeSet.remove(node);
                EventInfo eventInfo = new EventInfo("NODE_REMOVE");
                eventInfo.setParam("node", node);
                this.appContext.getEventCenter().publishSync(eventInfo);
                LOGGER.info("Remove {}", node);
            }
        }
    }

    @Override
    public void addNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (Node node : nodes) {
            this.addNode(node);
        }
    }

    @Override
    public void removeNodes(List<Node> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (Node node : nodes) {
            this.removeNode(node);
        }
    }
}

